/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolListMap
implements Cloneable {
    private HashMap<ITool, List<ITool>> fMap = new HashMap();
    private CollectionEntrySet fCollectionEntrySet;

    public void add(ITool key, ITool value) {
        List<ITool> l = this.get(key, true);
        l.add(value);
    }

    public List<ITool> removeAll(ITool key) {
        return this.fMap.remove(key);
    }

    public List<ITool> get(ITool key, boolean create) {
        List<ITool> l = this.fMap.get(key);
        if (l == null && create) {
            l = this.newList(1);
            this.fMap.put(key, l);
        }
        return l;
    }

    public List<ITool> valuesToCollection(List<ITool> c) {
        if (c == null) {
            c = this.newList(20);
        }
        for (List<ITool> l : this.fMap.values()) {
            c.addAll(l);
        }
        return c;
    }

    protected List<ITool> newList(int size) {
        return new ArrayList<ITool>(size);
    }

    protected List<ITool> cloneList(List<ITool> l) {
        return (List)((ArrayList)l).clone();
    }

    public List<ITool> putValuesToCollection(List<ITool> c) {
        for (CollectionEntry entry : this.collectionEntrySet()) {
            List<ITool> l = entry.getValue();
            c.addAll(l);
        }
        return c;
    }

    public void remove(ITool key, ITool value) {
        List<ITool> c = this.get(key, false);
        if (c != null && c.remove(value) && c.size() == 0) {
            this.fMap.remove(key);
        }
    }

    public ITool get(ITool key, int num) {
        List<ITool> l = this.get(key, false);
        if (l != null) {
            return l.get(num);
        }
        return null;
    }

    public ITool remove(ITool key, int num) {
        List<ITool> l = this.get(key, false);
        if (l != null) {
            ITool result = null;
            if (l.size() > num) {
                result = l.remove(num);
            }
            return result;
        }
        return null;
    }

    public ITool removeLast(ITool key) {
        List<ITool> l = this.get(key, false);
        if (l != null) {
            ITool result = null;
            if (l.size() > 0) {
                result = l.remove(l.size() - 1);
            }
            return result;
        }
        return null;
    }

    public void removeAll(ITool key, List<ITool> values) {
        List<ITool> c = this.get(key, false);
        if (c != null && c.removeAll(values) && c.size() == 0) {
            this.fMap.remove(key);
        }
    }

    public void clearEmptyLists() {
        Iterator<Map.Entry<ITool, List<ITool>>> iter = this.fMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ITool, List<ITool>> entry = iter.next();
            if (entry.getValue().size() != 0) continue;
            iter.remove();
        }
    }

    public Set<CollectionEntry> collectionEntrySet() {
        if (this.fCollectionEntrySet == null) {
            this.fCollectionEntrySet = new CollectionEntrySet();
        }
        return this.fCollectionEntrySet;
    }

    public Object clone() {
        try {
            HashMap clone2;
            ToolListMap clone = (ToolListMap)super.clone();
            clone.fMap = clone2 = (HashMap)this.fMap.clone();
            for (Map.Entry<ITool, List<ITool>> entry : clone.fMap.entrySet()) {
                entry.setValue(this.cloneList(entry.getValue()));
            }
        }
        catch (CloneNotSupportedException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CollectionEntry {
        private Map.Entry<ITool, List<ITool>> fEntry;

        CollectionEntry(Map.Entry<ITool, List<ITool>> entry) {
            this.fEntry = entry;
        }

        public ITool getKey() {
            return this.fEntry.getKey();
        }

        public List<ITool> getValue() {
            return this.fEntry.getValue();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CollectionEntry)) {
                return false;
            }
            return this.fEntry.equals(((CollectionEntry)obj).fEntry);
        }

        public int hashCode() {
            return this.fEntry.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionEntrySet
    extends AbstractSet<CollectionEntry> {
        private Set<Map.Entry<ITool, List<ITool>>> fMapEntrySet;

        private CollectionEntrySet() {
            this.fMapEntrySet = ToolListMap.this.fMap.entrySet();
        }

        @Override
        public Iterator<CollectionEntry> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return this.fMapEntrySet.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Iter
        implements Iterator<CollectionEntry> {
            private Iterator<Map.Entry<ITool, List<ITool>>> fIter;

            private Iter() {
                this.fIter = CollectionEntrySet.this.fMapEntrySet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.fIter.hasNext();
            }

            @Override
            public CollectionEntry next() {
                return new CollectionEntry(this.fIter.next());
            }

            @Override
            public void remove() {
                this.fIter.remove();
            }
        }
    }
}

