/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ProjectConverter;
import org.eclipse.cdt.managedbuilder.projectconverter.ConverterMessages;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProject12;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProject20;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProject21;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProject30;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProject31;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateManagedProjectManager {
    private static ThreadLocal<Map<String, UpdateManagedProjectManager>> fThreadInfo = new ThreadLocal();
    private static IOverwriteQuery fBackupFileOverwriteQuery = null;
    private static IOverwriteQuery fOpenQuestionQuery = null;
    private static IOverwriteQuery fUpdateProjectQuery = null;
    private ManagedBuildInfo fConvertedInfo = null;
    private boolean fIsInfoReadOnly = false;
    private final IProject fProject;

    private UpdateManagedProjectManager(IProject project) {
        this.fProject = project;
    }

    public static void setBackupFileOverwriteQuery(IOverwriteQuery backupFileOverwriteQuery) {
        fBackupFileOverwriteQuery = backupFileOverwriteQuery;
    }

    public static void setUpdateProjectQuery(IOverwriteQuery updateProjectQuery) {
        fUpdateProjectQuery = updateProjectQuery;
    }

    private static synchronized UpdateManagedProjectManager getUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            mngr = UpdateManagedProjectManager.createUpdateManager(project);
        }
        return mngr;
    }

    private static UpdateManagedProjectManager getExistingUpdateManager(IProject project) {
        Map<String, UpdateManagedProjectManager> map = UpdateManagedProjectManager.getManagerMap(false);
        return map != null ? map.get(project.getName()) : null;
    }

    private static UpdateManagedProjectManager createUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = new UpdateManagedProjectManager(project);
        UpdateManagedProjectManager.getManagerMap(true).put(project.getName(), mngr);
        return mngr;
    }

    public static void addInfo(IProject project, ManagedBuildInfo info) {
        UpdateManagedProjectManager.getUpdateManager(project).setBuildInfo(info);
    }

    public static void delInfo(IProject project) {
        UpdateManagedProjectManager.removeUpdateManager(project);
    }

    private static void removeUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            return;
        }
        UpdateManagedProjectManager.getManagerMap(false).remove(project.getName());
    }

    private static Map<String, UpdateManagedProjectManager> getManagerMap(boolean create) {
        Map<String, UpdateManagedProjectManager> map = fThreadInfo.get();
        if (map == null && create) {
            map = new HashMap<String, UpdateManagedProjectManager>();
            fThreadInfo.set(map);
        }
        return map;
    }

    protected static Version getManagedBuildInfoVersion(String version) {
        if (version == null) {
            version = "1.2";
        }
        return new Version(version);
    }

    public static boolean isCompatibleProject(IManagedBuildInfo info) {
        if (info == null) {
            return false;
        }
        Version projVersion = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
        Version compVersion = ManagedBuildManager.getBuildInfoVersion();
        return compVersion.equals((Object)projVersion);
    }

    static void backupFile(IFile settingsFile, String suffix, IProgressMonitor monitor, IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null || mngr.fIsInfoReadOnly) {
            return;
        }
        IProject destFolder = project;
        IFile dstFile = destFolder.getFile((IPath)new Path(String.valueOf(settingsFile.getName()) + suffix));
        mngr.backupFile(settingsFile, dstFile, monitor, project, fBackupFileOverwriteQuery);
    }

    public static void backupSettingsFile(IFile settingsFile, String suffix, IProgressMonitor monitor, IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getUpdateManager(project);
        if (mngr == null || mngr.fIsInfoReadOnly) {
            return;
        }
        IProject destFolder = project;
        IFile dstFile = destFolder.getFile((IPath)new Path(String.valueOf(settingsFile.getName()) + suffix));
        mngr.backupFile(settingsFile, dstFile, monitor, project, fBackupFileOverwriteQuery);
    }

    private void backupFile(IFile srcFile, IFile dstFile, IProgressMonitor monitor, IProject project, IOverwriteQuery query) {
        File src = srcFile.getLocation().toFile();
        File dst = dstFile.getLocation().toFile();
        this.backupFile(src, dst, monitor, project, query);
    }

    private void backupFile(File srcFile, File dstFile, IProgressMonitor monitor, IProject project, IOverwriteQuery query) {
        try {
            if (dstFile.exists()) {
                boolean shouldUpdate = query != null ? ProjectConverter.getBooleanFromQueryAnswer(query.queryOverwrite(dstFile.getName())) : ProjectConverter.openQuestion((IResource)this.fProject, "UpdateManagedProjectManager.0", ConverterMessages.getResourceString("UpdateManagedProjectManager.0"), ConverterMessages.getFormattedString("UpdateManagedProjectManager.1", new String[]{dstFile.getName(), project.getName()}), fOpenQuestionQuery, false);
                if (shouldUpdate) {
                    dstFile.delete();
                } else {
                    throw new OperationCanceledException(ConverterMessages.getFormattedString("UpdateManagedProjectManager.2", project.getName()));
                }
            }
            this.copyFile(srcFile, dstFile);
        }
        catch (Exception exception) {
            this.fIsInfoReadOnly = true;
        }
    }

    void copyFile(File src, File dst) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = fis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void restoreFile(String backupFileName, String restoreFileName, IProgressMonitor monitor, IProject project) {
        IProject destFolder = project;
        File restoreFile = destFolder.getFile((IPath)new Path(restoreFileName)).getLocation().toFile();
        File backupFile = destFolder.getFile((IPath)new Path(backupFileName)).getLocation().toFile();
        try {
            if (restoreFile.exists()) {
                restoreFile.delete();
            }
            this.copyFile(backupFile, restoreFile);
        }
        catch (Exception exception) {
            this.fIsInfoReadOnly = true;
        }
    }

    public static ManagedBuildInfo getConvertedManagedBuildInfo(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            return null;
        }
        return mngr.getConvertedManagedBuildInfo();
    }

    private ManagedBuildInfo getConvertedManagedBuildInfo() {
        return this.fConvertedInfo;
    }

    private void setBuildInfo(ManagedBuildInfo info) {
        this.fConvertedInfo = info;
    }

    private void doProjectUpdate(ManagedBuildInfo info) throws CoreException {
        this.fConvertedInfo = info;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFile settingsFile = this.fProject.getFile(".cdtbuild");
        IFile backupFile = this.fProject.getFile(".cdtbuild_initial");
        if (UpdateManagedProjectManager.isCompatibleProject(info)) {
            return;
        }
        try {
            try {
                if (!settingsFile.getLocation().toFile().exists()) {
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getResourceString("UpdateManagedProjectManager.6"), null));
                }
                this.backupFile(settingsFile, backupFile, (IProgressMonitor)monitor, this.fProject, new IOverwriteQuery(){

                    public String queryOverwrite(String file) {
                        return "ALL";
                    }
                });
                Version version = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
                boolean shouldUpdate = fUpdateProjectQuery != null ? ProjectConverter.getBooleanFromQueryAnswer(fUpdateProjectQuery.queryOverwrite(this.fProject.getFullPath().toString())) : ProjectConverter.openQuestion((IResource)this.fProject, "UpdateManagedProjectManager.3", ConverterMessages.getResourceString("UpdateManagedProjectManager.3"), ConverterMessages.getFormattedString("UpdateManagedProjectManager.4", new String[]{this.fProject.getName(), version.toString(), ManagedBuildManager.getBuildInfoVersion().toString()}), fOpenQuestionQuery, false);
                if (!shouldUpdate) {
                    this.fIsInfoReadOnly = true;
                    throw new CoreException((IStatus)new Status(8, ManagedBuilderCorePlugin.getUniqueIdentifier(), ConverterMessages.getResourceString("UpdateManagedProjectManager.7")));
                }
                IFile projectFile = this.fProject.getFile(".project");
                if (projectFile.exists()) {
                    UpdateManagedProjectManager.backupFile(projectFile, "_initial", (IProgressMonitor)monitor, this.fProject);
                }
                if (version.equals((Object)new Version(1, 2, 0))) {
                    UpdateManagedProject12.doProjectUpdate((IProgressMonitor)monitor, this.fProject);
                    version = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
                }
                if (version.equals((Object)new Version(2, 0, 0))) {
                    UpdateManagedProject20.doProjectUpdate((IProgressMonitor)monitor, this.fProject);
                    version = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
                }
                if (version.equals((Object)new Version(2, 1, 0))) {
                    UpdateManagedProject21.doProjectUpdate((IProgressMonitor)monitor, this.fProject);
                    version = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
                }
                if (version.equals((Object)new Version(3, 0, 0))) {
                    UpdateManagedProject30.doProjectUpdate((IProgressMonitor)monitor, this.fProject);
                    version = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
                }
                if (new Version(4, 0, 0).compareTo(version) > 0) {
                    UpdateManagedProject31.doProjectUpdate((IProgressMonitor)monitor, this.fProject);
                    version = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
                }
                if (!UpdateManagedProjectManager.isCompatibleProject(info)) {
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProjectManager.5", new String[]{ManagedBuildManager.getBuildInfoVersion().toString(), version.toString(), info.getManagedProject().getId()}), null));
                }
            }
            catch (CoreException e) {
                this.fIsInfoReadOnly = true;
                throw e;
            }
        }
        finally {
            if (this.fIsInfoReadOnly) {
                this.restoreFile(backupFile.getName(), settingsFile.getName(), (IProgressMonitor)monitor, this.fProject);
                info.setReadOnly(true);
            }
        }
    }

    public static void updateProject(IProject project, ManagedBuildInfo info) throws CoreException {
        try {
            UpdateManagedProjectManager.getUpdateManager(project).doProjectUpdate(info);
        }
        catch (Throwable throwable) {
            UpdateManagedProjectManager.removeUpdateManager(project);
            IWorkspace workspace = project.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().refreshRule((IResource)project);
            WorkspaceJob job = new WorkspaceJob("Refresh Project", project){
                private final /* synthetic */ IProject val$project;
                {
                    this.val$project = iProject;
                    super($anonymous0);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    this.val$project.refreshLocal(1, null);
                    return Status.OK_STATUS;
                }
            };
            job.setRule(rule);
            job.schedule();
            throw throwable;
        }
        UpdateManagedProjectManager.removeUpdateManager(project);
        IWorkspace workspace = project.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().refreshRule((IResource)project);
        WorkspaceJob job = new /* invalid duplicate definition of identical inner class */;
        job.setRule(rule);
        job.schedule();
    }
}

