/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.cdt.ui.CDTStructureBridge;
import org.eclipse.mylyn.internal.cdt.ui.Messages;

public class LandmarkMarkerManager
extends AbstractContextListener {
    private static final String ID_MARKER_LANDMARK = "org.eclipse.mylyn.context.ui.markers.landmark";
    private final Map<IInteractionElement, Long> markerMap = new HashMap<IInteractionElement, Long>();

    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case PRE_ACTIVATED: {
                break;
            }
            case ACTIVATED: {
                this.modelUpdated();
                break;
            }
            case DEACTIVATED: {
                this.modelUpdated();
                break;
            }
            case CLEARED: {
                this.modelUpdated();
                break;
            }
            case INTEREST_CHANGED: {
                break;
            }
            case LANDMARKS_ADDED: {
                for (IInteractionElement element : event.getElements()) {
                    this.addedLandmark(element);
                }
                break;
            }
            case LANDMARKS_REMOVED: {
                for (IInteractionElement element : event.getElements()) {
                    this.removedLandmark(element);
                }
                break;
            }
        }
    }

    private void modelUpdated() {
        try {
            for (IInteractionElement node : this.markerMap.keySet()) {
                this.removedLandmark(node);
            }
            this.markerMap.clear();
            for (IInteractionElement node : ContextCore.getContextManager().getActiveLandmarks()) {
                this.addedLandmark(node);
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "could not update landmark markers", t));
        }
    }

    private void addedLandmark(final IInteractionElement node) {
        if (node == null || node.getContentType() == null) {
            return;
        }
        if (node.getContentType().equals("c/c++")) {
            ICElement element = CDTStructureBridge.getElementForHandle(node.getHandleIdentifier());
            if (element == null || !element.exists()) {
                return;
            }
            if (element instanceof IMethod || element instanceof IFunction) {
                try {
                    final ISourceRange range = ((ISourceReference)element).getSourceRange();
                    final IResource resource = element.getUnderlyingResource();
                    if (resource instanceof IFile) {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                IMarker marker = resource.createMarker(LandmarkMarkerManager.ID_MARKER_LANDMARK);
                                if (marker != null && range != null) {
                                    marker.setAttribute("charStart", range.getStartPos());
                                    marker.setAttribute("charEnd", range.getStartPos() + range.getLength());
                                    marker.setAttribute("message", (Object)Messages.LandmarkMarkerManager_Mylyn_Landmark);
                                    marker.setAttribute("severity", 0);
                                    LandmarkMarkerManager.this.markerMap.put(node, marker.getId());
                                }
                            }
                        };
                        resource.getWorkspace().run(runnable, null);
                    }
                }
                catch (CModelException e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "could not update markers", (Throwable)e));
                }
                catch (CoreException e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "could not update markers", (Throwable)e));
                }
            }
        }
    }

    private void removedLandmark(final IInteractionElement node) {
        if (node == null) {
            return;
        }
        if (node.getContentType().equals("c/c++")) {
            ICElement element = CDTStructureBridge.getElementForHandle(node.getHandleIdentifier());
            if (element == null || !element.exists()) {
                return;
            }
            if (element.getAncestor(60) != null && element instanceof ISourceReference) {
                try {
                    final IResource resource = element.getUnderlyingResource();
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            if (resource != null) {
                                try {
                                    long id;
                                    IMarker marker;
                                    if (LandmarkMarkerManager.this.markerMap.containsKey(node) && (marker = resource.getMarker(id = ((Long)LandmarkMarkerManager.this.markerMap.get(node)).longValue())) != null) {
                                        marker.delete();
                                    }
                                }
                                catch (NullPointerException e) {
                                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Could not update markers.", (Throwable)e));
                                }
                            }
                        }
                    };
                    resource.getWorkspace().run(runnable, null);
                }
                catch (CModelException cModelException) {
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "could not update landmark markers", (Throwable)e));
                }
            }
        }
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void elementDeleted(IInteractionElement node) {
    }
}

