/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.p2.touchpoint.natives.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateAction
extends ProvisioningAction {
    private static final String PARM_MAP = "map";
    static int n;

    public IStatus execute(Map<String, Object> parameters) {
        String targetFileName = (String)parameters.get("targetFile");
        File targetFile = new File(targetFileName);
        if (!targetFile.exists()) {
            return new Status(2, "org.eclipse.cdt.p2", String.valueOf(targetFileName) + " not found");
        }
        String mapString = (String)parameters.get(PARM_MAP);
        String[] mapStrings = mapString.split("!");
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < mapStrings.length) {
            if (i == mapStrings.length - 1) break;
            map.put(mapStrings[i], mapStrings[i + 1]);
            i += 2;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(targetFile));
            File tmpFile = new File(targetFile.getParentFile(), "translate" + n++);
            FileWriter writer = new FileWriter(tmpFile);
            Pattern pattern = Pattern.compile("!(.*)!");
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    String value = (String)map.get(matcher.group(1));
                    if (value == null) continue;
                    line = line.replace(matcher.group(), value);
                    matcher.reset(line);
                }
                writer.write(line);
                writer.write(10);
                line = reader.readLine();
            }
            reader.close();
            writer.close();
            targetFile.delete();
            tmpFile.renameTo(targetFile);
        }
        catch (IOException e) {
            return new Status(2, "org.eclipse.cdt.p2", e.getLocalizedMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }
}

