/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.ui.refactoring.AddDeclarationNodeToClassChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoringDescription;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractedFunctionConstructionHelper;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.NonExtractableStmtFinder;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ReturnStatementFinder;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.SimilarFinderVisitor;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.TrailName;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.TrailNodeEqualityChecker;
import org.eclipse.cdt.internal.ui.refactoring.utils.ASTHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.CPPASTAllVisitor;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractFunctionRefactoring
extends CRefactoring {
    public static final String ID = "org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring";
    static final Integer NULL_INTEGER = 0;
    static final char[] ZERO = "0".toCharArray();
    NodeContainer container;
    final ExtractFunctionInformation info;
    final Map<String, Integer> names;
    final Container<Integer> namesCounter;
    final Container<Integer> trailPos;
    private final Container<Integer> returnNumber;
    protected boolean hasNameResolvingForSimilarError = false;
    HashMap<String, Integer> nameTrail;
    private ExtractedFunctionConstructionHelper extractedFunctionConstructionHelper;
    private final INodeFactory factory = CPPNodeFactory.getDefault();

    public ExtractFunctionRefactoring(IFile file, ISelection selection, ExtractFunctionInformation info, ICProject project) {
        super(file, selection, null, project);
        this.info = info;
        this.name = Messages.ExtractFunctionRefactoring_ExtractFunction;
        this.names = new HashMap<String, Integer>();
        this.namesCounter = new Container<Integer>(NULL_INTEGER);
        this.trailPos = new Container<Integer>(NULL_INTEGER);
        this.returnNumber = new Container<Integer>(NULL_INTEGER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        try {
            this.lockIndex();
            try {
                RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
                if (status.hasError()) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
                this.container = this.findExtractableNodes();
                sm.worked(1);
                if (ExtractFunctionRefactoring.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                this.checkForNonExtractableStatements(this.container, this.initStatus);
                sm.worked(1);
                if (ExtractFunctionRefactoring.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                this.container.findAllNames();
                this.markWriteAccess();
                sm.worked(1);
                if (ExtractFunctionRefactoring.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                this.container.getAllAfterUsedNames();
                this.info.setAllUsedNames(this.container.getUsedNamesUnique());
                if (this.container.size() < 1) {
                    this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_NoStmtSelected);
                    sm.done();
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                if (this.container.getAllDeclaredInScope().size() > 1) {
                    this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_TooManySelected);
                } else if (this.container.getAllDeclaredInScope().size() == 1) {
                    this.info.setInScopeDeclaredVariable(this.container.getAllDeclaredInScope().get(0));
                }
                this.extractedFunctionConstructionHelper = ExtractedFunctionConstructionHelper.createFor(this.container.getNodesToWrite());
                boolean isExtractExpression = this.container.getNodesToWrite().get(0) instanceof IASTExpression;
                this.info.setExtractExpression(isExtractExpression);
                this.info.setDeclarator(this.getDeclaration(this.container.getNodesToWrite().get(0)));
                MethodContext context = NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.getIndex());
                this.info.setMethodContext(context);
                if (this.info.getInScopeDeclaredVariable() != null) {
                    this.info.getInScopeDeclaredVariable().setUserSetIsReturnValue(true);
                }
                int i = 0;
                while (true) {
                    NodeContainer.NameInformation name;
                    if (i >= this.info.getAllUsedNames().size()) {
                        sm.done();
                        return this.initStatus;
                    }
                    if (!this.info.getAllUsedNames().get(i).isDeclarationInScope() && !(name = this.info.getAllUsedNames().get(i)).isReturnValue()) {
                        name.setUserSetIsReference(name.isReference());
                    }
                    ++i;
                }
            }
            finally {
                this.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this.initStatus;
    }

    private void markWriteAccess() throws CoreException {
        List<NodeContainer.NameInformation> paras = this.container.getNames();
        for (NodeContainer.NameInformation name : paras) {
            int flag = CPPVariableReadWriteFlags.getReadWriteFlags((IASTName)name.getName());
            if ((flag & 0x40) == 0) continue;
            name.setWriteAccess(true);
        }
    }

    private void checkForNonExtractableStatements(NodeContainer cont, RefactoringStatus status) {
        NonExtractableStmtFinder vis = new NonExtractableStmtFinder();
        for (IASTNode node : cont.getNodesToWrite()) {
            node.accept((ASTVisitor)vis);
            if (vis.containsContinue()) {
                this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Continue);
                break;
            }
            if (!vis.containsBreak()) continue;
            this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Break);
            break;
        }
        ReturnStatementFinder rFinder = new ReturnStatementFinder();
        for (IASTNode node : cont.getNodesToWrite()) {
            node.accept((ASTVisitor)rFinder);
            if (!rFinder.containsReturn()) continue;
            this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Return);
            break;
        }
    }

    private ICPPASTFunctionDeclarator getDeclaration(IASTNode node) {
        IASTFunctionDeclarator declarator;
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        if (node != null && (declarator = ((IASTFunctionDefinition)node).getDeclarator()) instanceof ICPPASTFunctionDeclarator) {
            return (ICPPASTFunctionDeclarator)declarator;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus finalConditions = null;
        try {
            this.lockIndex();
            try {
                finalConditions = super.checkFinalConditions(pm);
                CPPASTName astMethodName = new CPPASTName(this.info.getMethodName().toCharArray());
                MethodContext context = NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.getIndex());
                if (context.getType() == MethodContext.ContextType.METHOD && !context.isInline()) {
                    ICPPASTCompositeTypeSpecifier classDeclaration = (ICPPASTCompositeTypeSpecifier)context.getMethodDeclaration().getParent();
                    IASTSimpleDeclaration methodDeclaration = this.getDeclaration((IASTName)astMethodName);
                    if (this.isMethodAllreadyDefined(methodDeclaration, classDeclaration, this.getIndex())) {
                        finalConditions.addError(Messages.ExtractFunctionRefactoring_NameInUse);
                        RefactoringStatus refactoringStatus = finalConditions;
                        return refactoringStatus;
                    }
                }
                Iterator<NodeContainer.NameInformation> iterator = this.info.getAllUsedNames().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return finalConditions;
                    }
                    NodeContainer.NameInformation name = iterator.next();
                    if (!name.isUserSetIsReturnValue()) continue;
                    this.info.setReturnVariable(name);
                }
            }
            finally {
                this.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return finalConditions;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        try {
            this.lockIndex();
            try {
                CPPASTName astMethodName = new CPPASTName(this.info.getMethodName().toCharArray());
                MethodContext context = NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.getIndex());
                if (context.getType() == MethodContext.ContextType.METHOD && !context.isInline()) {
                    this.createMethodDeclaration((IASTName)astMethodName, context, collector);
                }
                IASTNode firstNode = this.container.getNodesToWrite().get(0);
                Path implPath = new Path(firstNode.getContainingFilename());
                IFile implementationFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)implPath);
                this.createMethodDefinition((IASTName)astMethodName, context, firstNode, implementationFile, collector);
                this.createMethodCalls((IASTName)astMethodName, implementationFile, context, collector);
            }
            finally {
                this.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void createMethodCalls(IASTName astMethodName, IFile implementationFile, MethodContext context, ModificationCollector collector) throws CoreException {
        String title = context.getType() == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionRefactoring_CreateMethodCall : Messages.ExtractFunctionRefactoring_CreateFunctionCall;
        IASTNode methodCall = this.getMethodCall(astMethodName);
        IASTNode firstNodeToWrite = this.container.getNodesToWrite().get(0);
        ASTRewrite rewriter = collector.rewriterForTranslationUnit(firstNodeToWrite.getTranslationUnit());
        TextEditGroup editGroup = new TextEditGroup(title);
        if (methodCall instanceof IASTDeclaration) {
            CPPASTDeclarationStatement declarationStatement = new CPPASTDeclarationStatement((IASTDeclaration)methodCall);
            methodCall = declarationStatement;
        }
        this.insertCallintoTree(methodCall, this.container.getNodesToWrite(), rewriter, editGroup);
        if (this.info.isReplaceDuplicates()) {
            this.replaceSimilar(collector, astMethodName, implementationFile, context.getType());
        }
        for (IASTNode node : this.container.getNodesToWrite()) {
            if (node == firstNodeToWrite) continue;
            rewriter.remove(node, editGroup);
        }
    }

    private void insertCallintoTree(IASTNode methodCall, List<IASTNode> list, ASTRewrite rewriter, TextEditGroup editGroup) {
        IASTNode firstNode = list.get(0);
        if (list.size() > 1 && firstNode.getParent() instanceof IASTBinaryExpression && firstNode.getParent().getParent() instanceof IASTBinaryExpression) {
            IASTBinaryExpression parent = (IASTBinaryExpression)firstNode.getParent();
            IASTExpression leftSubTree = parent.getOperand1();
            int op = parent.getOperator();
            CPPASTBinaryExpression newParentNode = new CPPASTBinaryExpression();
            IASTBinaryExpression rootBinExp = this.getRootBinExp(parent, list);
            newParentNode.setParent(rootBinExp.getParent());
            newParentNode.setOperand1(leftSubTree.copy(IASTNode.CopyStyle.withLocations));
            newParentNode.setOperator(op);
            newParentNode.setOperand2((IASTExpression)methodCall);
            rewriter.replace((IASTNode)rootBinExp, (IASTNode)newParentNode, editGroup);
        } else {
            rewriter.replace(firstNode, methodCall, editGroup);
        }
    }

    private IASTBinaryExpression getRootBinExp(IASTBinaryExpression binExp, List<IASTNode> nodeList) {
        while (binExp.getParent() instanceof IASTBinaryExpression && nodeList.contains(((IASTBinaryExpression)binExp.getParent()).getOperand2())) {
            binExp = (IASTBinaryExpression)binExp.getParent();
        }
        return binExp;
    }

    private void createMethodDefinition(IASTName astMethodName, MethodContext context, IASTNode firstNode, IFile implementationFile, ModificationCollector collector) {
        IASTFunctionDefinition node = NodeHelper.findFunctionDefinitionInAncestors(firstNode);
        if (node != null) {
            String title = context.getType() == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionRefactoring_CreateMethodDef : Messages.ExtractFunctionRefactoring_CreateFunctionDef;
            ASTRewrite rewriter = collector.rewriterForTranslationUnit(node.getTranslationUnit());
            this.addMethod(astMethodName, context, rewriter, (IASTNode)node, new TextEditGroup(title));
        }
    }

    private void createMethodDeclaration(IASTName astMethodName, MethodContext context, ModificationCollector collector) {
        ICPPASTCompositeTypeSpecifier classDeclaration = (ICPPASTCompositeTypeSpecifier)context.getMethodDeclaration().getParent();
        IASTSimpleDeclaration methodDeclaration = this.getDeclaration(collector, astMethodName);
        AddDeclarationNodeToClassChange.createChange(classDeclaration, this.info.getVisibility(), (IASTNode)methodDeclaration, false, collector);
    }

    private void replaceSimilar(ModificationCollector collector, IASTName astMethodName, IFile implementationFile, MethodContext.ContextType contextType) {
        LinkedList<IASTNode> nodesToRewriteWithoutComments = new LinkedList<IASTNode>();
        for (IASTNode node : this.container.getNodesToWrite()) {
            if (node instanceof IASTComment) continue;
            nodesToRewriteWithoutComments.add(node);
        }
        Vector<IASTNode> initTrail = this.getTrail(nodesToRewriteWithoutComments);
        String title = contextType == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionRefactoring_CreateMethodCall : Messages.ExtractFunctionRefactoring_CreateFunctionCall;
        if (!this.hasNameResolvingForSimilarError) {
            this.ast.accept((ASTVisitor)new SimilarFinderVisitor(this, collector, initTrail, implementationFile, astMethodName, nodesToRewriteWithoutComments, title));
        }
    }

    protected Vector<IASTNode> getTrail(List<IASTNode> stmts) {
        final Vector<IASTNode> trail = new Vector<IASTNode>();
        this.nameTrail = new HashMap();
        final Container<Integer> trailCounter = new Container<Integer>(NULL_INTEGER);
        for (IASTNode node : stmts) {
            node.accept((ASTVisitor)new CPPASTAllVisitor(){

                public int visitAll(IASTNode node) {
                    if (node instanceof IASTComment) {
                        return super.visitAll(node);
                    }
                    if (node instanceof IASTNamedTypeSpecifier) {
                        trail.add(node);
                        return 1;
                    }
                    if (node instanceof IASTName) {
                        if (node instanceof ICPPASTConversionName && node instanceof ICPPASTOperatorName && node instanceof ICPPASTTemplateId) {
                            trail.add(node);
                            return super.visitAll(node);
                        }
                        IASTName name = (IASTName)node;
                        TrailName trailName = new TrailName(name);
                        int actCount = (Integer)trailCounter.getObject();
                        if (ExtractFunctionRefactoring.this.nameTrail.containsKey(name.getRawSignature())) {
                            Integer value = ExtractFunctionRefactoring.this.nameTrail.get(name.getRawSignature());
                            actCount = value;
                        } else {
                            trailCounter.setObject(++actCount);
                            ExtractFunctionRefactoring.this.nameTrail.put(name.getRawSignature(), (Integer)trailCounter.getObject());
                        }
                        trailName.setNameNumber(actCount);
                        if (ExtractFunctionRefactoring.this.info.getReturnVariable() != null && ExtractFunctionRefactoring.this.info.getReturnVariable().getName().getRawSignature().equals(name.getRawSignature())) {
                            ExtractFunctionRefactoring.this.returnNumber.setObject(actCount);
                        }
                        trail.add(trailName);
                        return 1;
                    }
                    trail.add(node);
                    return super.visitAll(node);
                }
            });
        }
        return trail;
    }

    protected boolean isStatementInTrail(IASTStatement stmt, final Vector<IASTNode> trail, IIndex index) {
        final Container<Boolean> same = new Container<Boolean>(Boolean.TRUE);
        final TrailNodeEqualityChecker equalityChecker = new TrailNodeEqualityChecker(this.names, this.namesCounter, index);
        stmt.accept((ASTVisitor)new CPPASTAllVisitor(){

            public int visitAll(IASTNode node) {
                int pos = ExtractFunctionRefactoring.this.trailPos.getObject();
                if (trail.size() <= 0 || pos >= trail.size()) {
                    same.setObject(Boolean.FALSE);
                    return 2;
                }
                if (node instanceof IASTComment) {
                    return super.visitAll(node);
                }
                IASTNode trailNode = (IASTNode)trail.get(pos);
                ExtractFunctionRefactoring.this.trailPos.setObject(pos + 1);
                if (equalityChecker.isEquals(trailNode, node)) {
                    if (node instanceof ICPPASTQualifiedName || node instanceof IASTNamedTypeSpecifier) {
                        return 1;
                    }
                    return super.visitAll(node);
                }
                same.setObject(new Boolean(false));
                return 2;
            }
        });
        return same.getObject();
    }

    private boolean isMethodAllreadyDefined(IASTSimpleDeclaration methodDeclaration, ICPPASTCompositeTypeSpecifier classDeclaration, IIndex index) {
        TrailNodeEqualityChecker equalityChecker = new TrailNodeEqualityChecker(this.names, this.namesCounter, index);
        IBinding bind = classDeclaration.getName().resolveBinding();
        IASTStandardFunctionDeclarator declarator = (IASTStandardFunctionDeclarator)methodDeclaration.getDeclarators()[0];
        String name = new String(declarator.getName().toCharArray());
        if (bind instanceof ICPPClassType) {
            ICPPMethod[] methods;
            IField[] fields;
            ICPPClassType classBind = (ICPPClassType)bind;
            IField[] iFieldArray = fields = classBind.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (field.getName().equals(name)) {
                    return true;
                }
                ++n2;
            }
            ICPPMethod[] iCPPMethodArray = methods = classBind.getAllDeclaredMethods();
            int n3 = methods.length;
            n = 0;
            while (n < n3) {
                ICPPParameter[] parameters;
                ICPPMethod method = iCPPMethodArray[n];
                if (!method.takesVarArgs() && name.equals(method.getName()) && (parameters = method.getParameters()).length == declarator.getParameters().length) {
                    int i = 0;
                    while (i < parameters.length) {
                        IASTName[] origParameterName = this.ast.getDeclarationsInAST((IBinding)parameters[i]);
                        IASTParameterDeclaration origParameter = (IASTParameterDeclaration)origParameterName[0].getParent().getParent();
                        IASTParameterDeclaration newParameter = declarator.getParameters()[i];
                        if (!equalityChecker.isEquals((IASTNode)origParameter.getDeclSpecifier(), (IASTNode)newParameter.getDeclSpecifier()) || !ASTHelper.samePointers(origParameter.getDeclarator().getPointerOperators(), newParameter.getDeclarator().getPointerOperators(), equalityChecker)) break;
                        if (i >= parameters.length - 1) {
                            return true;
                        }
                        ++i;
                    }
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    private void addMethod(IASTName astMethodName, MethodContext context, ASTRewrite rewriter, IASTNode insertpoint, TextEditGroup group) {
        ASTRewrite subRW;
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        if (context.getType() == MethodContext.ContextType.METHOD && context.getMethodQName() != null) {
            int i = 0;
            while (i < context.getMethodQName().getNames().length - 1) {
                qname.addName((IASTName)new CPPASTName(context.getMethodQName().getNames()[i].toCharArray()));
                ++i;
            }
        }
        qname.addName(astMethodName);
        CPPASTFunctionDefinition func = new CPPASTFunctionDefinition();
        func.setParent((IASTNode)this.ast);
        IASTDeclSpecifier returnType = this.getReturnType();
        func.setDeclSpecifier(returnType);
        IASTStandardFunctionDeclarator createdFunctionDeclarator = this.extractedFunctionConstructionHelper.createFunctionDeclarator((IASTName)qname, (IASTStandardFunctionDeclarator)this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getAllUsedNames(), this.ast.getASTNodeFactory());
        func.setDeclarator((IASTFunctionDeclarator)createdFunctionDeclarator);
        CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
        func.setBody((IASTStatement)compound);
        if (insertpoint.getParent() instanceof ICPPASTTemplateDeclaration) {
            CPPASTTemplateDeclaration templateDeclaration = new CPPASTTemplateDeclaration();
            templateDeclaration.setParent((IASTNode)this.ast);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = ((ICPPASTTemplateDeclaration)insertpoint.getParent()).getTemplateParameters();
            int n = iCPPASTTemplateParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter templateParameter = iCPPASTTemplateParameterArray[n2];
                templateDeclaration.addTemplateParameter(templateParameter.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
            templateDeclaration.setDeclaration((IASTDeclaration)func);
            subRW = rewriter.insertBefore(insertpoint.getParent().getParent(), insertpoint.getParent(), (IASTNode)templateDeclaration, group);
        } else {
            subRW = rewriter.insertBefore(insertpoint.getParent(), insertpoint, (IASTNode)func, group);
        }
        this.extractedFunctionConstructionHelper.constructMethodBody((IASTCompoundStatement)compound, this.container.getNodesToWrite(), subRW, group);
        NodeContainer.NameInformation returnVariable = this.info.getReturnVariable();
        if (returnVariable != null) {
            CPPASTReturnStatement returnStmt = new CPPASTReturnStatement();
            if (returnVariable.getDeclaration().getParent() instanceof IASTExpression) {
                IASTExpression returnValue = (IASTExpression)returnVariable.getDeclaration().getParent();
                returnStmt.setReturnValue(returnValue);
            } else {
                CPPASTIdExpression expr = new CPPASTIdExpression();
                if (returnVariable.getUserSetName() == null) {
                    expr.setName(this.newName(returnVariable.getName()));
                } else {
                    expr.setName((IASTName)new CPPASTName(returnVariable.getUserSetName().toCharArray()));
                }
                returnStmt.setReturnValue((IASTExpression)expr);
            }
            subRW.insertBefore((IASTNode)compound, null, (IASTNode)returnStmt, group);
        }
    }

    private IASTName newName(IASTName declaration) {
        return new CPPASTName(declaration.toCharArray());
    }

    private IASTDeclSpecifier getReturnType() {
        IASTNode firstNodeToWrite = this.container.getNodesToWrite().get(0);
        NodeContainer.NameInformation returnVariable = this.info.getReturnVariable();
        return this.extractedFunctionConstructionHelper.determineReturnType(firstNodeToWrite, returnVariable);
    }

    protected IASTNode getMethodCall(IASTName astMethodName, Map<String, Integer> trailNameTable, Map<String, Integer> similarNameTable, NodeContainer myContainer, NodeContainer mySimilarContainer) {
        CPPASTExpressionStatement stmt = new CPPASTExpressionStatement();
        CPPASTFunctionCallExpression callExpression = new CPPASTFunctionCallExpression();
        CPPASTIdExpression idExpression = new CPPASTIdExpression();
        idExpression.setName(astMethodName);
        ArrayList<IASTInitializerClause> args = new ArrayList<IASTInitializerClause>();
        Vector<IASTName> declarations = new Vector<IASTName>();
        CPPASTName retName = null;
        boolean theRetName = false;
        for (NodeContainer.NameInformation nameInfo : myContainer.getNames()) {
            Integer trailSeqNumber = trailNameTable.get(nameInfo.getDeclaration().getRawSignature());
            String orgName = null;
            for (Map.Entry<String, Integer> entry : similarNameTable.entrySet()) {
                if (!entry.getValue().equals(trailSeqNumber)) continue;
                orgName = entry.getKey();
                if (this.info.getReturnVariable() == null || !trailSeqNumber.equals(this.returnNumber.getObject())) continue;
                theRetName = true;
            }
            if (orgName == null) continue;
            boolean found = false;
            for (NodeContainer.NameInformation simNameInfo : mySimilarContainer.getNames()) {
                if (!orgName.equals(simNameInfo.getDeclaration().getRawSignature())) continue;
                this.addAParameterIfPossible(args, declarations, simNameInfo);
                found = true;
                if (!theRetName) continue;
                theRetName = false;
                retName = new CPPASTName(simNameInfo.getDeclaration().getRawSignature().toCharArray());
            }
            if (found) continue;
            CPPASTIdExpression expression = new CPPASTIdExpression();
            CPPASTName fieldName = new CPPASTName(orgName.toCharArray());
            expression.setName((IASTName)fieldName);
            args.add((IASTInitializerClause)expression);
            if (!theRetName) continue;
            theRetName = false;
            retName = fieldName;
        }
        callExpression.setArguments(args.toArray(new IASTInitializerClause[args.size()]));
        callExpression.setFunctionNameExpression((IASTExpression)idExpression);
        if (this.info.getReturnVariable() == null) {
            return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTExpression)callExpression);
        }
        return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTFunctionCallExpression)callExpression, (IASTName)retName);
    }

    private IASTNode getMethodCall(IASTName astMethodName) {
        CPPASTExpressionStatement stmt = new CPPASTExpressionStatement();
        CPPASTFunctionCallExpression callExpression = new CPPASTFunctionCallExpression();
        CPPASTIdExpression idExpression = new CPPASTIdExpression();
        idExpression.setName((IASTName)new CPPASTName(astMethodName.toCharArray()));
        List<IASTInitializerClause> args = this.getCallParameters();
        callExpression.setArguments(args.toArray(new IASTInitializerClause[args.size()]));
        callExpression.setFunctionNameExpression((IASTExpression)idExpression);
        if (this.info.getReturnVariable() == null) {
            return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTExpression)callExpression);
        }
        IASTName retname = this.newName(this.info.getReturnVariable().getName());
        return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTFunctionCallExpression)callExpression, retname);
    }

    private IASTNode getReturnAssignment(IASTExpressionStatement stmt, IASTFunctionCallExpression callExpression, IASTName retname) {
        if (this.info.getReturnVariable().equals(this.info.getInScopeDeclaredVariable())) {
            IASTSimpleDeclaration orgDecl = NodeHelper.findSimpleDeclarationInParents((IASTNode)this.info.getReturnVariable().getDeclaration());
            CPPASTSimpleDeclaration decl = new CPPASTSimpleDeclaration();
            decl.setDeclSpecifier(orgDecl.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations));
            CPPASTDeclarator declarator = new CPPASTDeclarator();
            declarator.setName(retname);
            IASTPointerOperator[] iASTPointerOperatorArray = orgDecl.getDeclarators()[0].getPointerOperators();
            int n = iASTPointerOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
                declarator.addPointerOperator(pointer.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
            CPPASTEqualsInitializer initializer = new CPPASTEqualsInitializer();
            initializer.setInitializerClause((IASTInitializerClause)callExpression);
            declarator.setInitializer((IASTInitializer)initializer);
            decl.addDeclarator((IASTDeclarator)declarator);
            return decl;
        }
        CASTBinaryExpression binaryExpression = new CASTBinaryExpression();
        binaryExpression.setOperator(17);
        CPPASTIdExpression nameExpression = new CPPASTIdExpression();
        nameExpression.setName(retname);
        binaryExpression.setOperand1((IASTExpression)nameExpression);
        binaryExpression.setOperand2((IASTExpression)callExpression);
        return this.getReturnAssignment(stmt, (IASTExpression)binaryExpression);
    }

    private IASTNode getReturnAssignment(IASTExpressionStatement stmt, IASTExpression callExpression) {
        IASTNode node = this.container.getNodesToWrite().get(0);
        return this.extractedFunctionConstructionHelper.createReturnAssignment(node, stmt, callExpression);
    }

    private IASTSimpleDeclaration getDeclaration(IASTName name) {
        CPPASTSimpleDeclaration simpleDecl = new CPPASTSimpleDeclaration();
        IASTStandardFunctionDeclarator declarator = this.extractedFunctionConstructionHelper.createFunctionDeclarator(name, (IASTStandardFunctionDeclarator)this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getAllUsedNames(), this.ast.getASTNodeFactory());
        simpleDecl.addDeclarator((IASTDeclarator)declarator);
        return simpleDecl;
    }

    private IASTSimpleDeclaration getDeclaration(ModificationCollector collector, IASTName name) {
        IASTDeclSpecifier declSpec = this.getReturnType();
        IASTSimpleDeclaration simpleDecl = this.factory.newSimpleDeclaration(declSpec);
        if (this.info.isVirtual() && declSpec instanceof ICPPASTDeclSpecifier) {
            ((ICPPASTDeclSpecifier)declSpec).setVirtual(true);
        }
        simpleDecl.setParent((IASTNode)this.ast);
        IASTStandardFunctionDeclarator declarator = this.extractedFunctionConstructionHelper.createFunctionDeclarator(name, (IASTStandardFunctionDeclarator)this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getAllUsedNames(), this.ast.getASTNodeFactory());
        simpleDecl.addDeclarator((IASTDeclarator)declarator);
        return simpleDecl;
    }

    private NodeContainer findExtractableNodes() {
        final NodeContainer container = new NodeContainer();
        this.ast.accept(new ASTVisitor(){
            {
                this.shouldVisitStatements = true;
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTStatement stmt) {
                if (SelectionHelper.isSelectedFile(ExtractFunctionRefactoring.this.region, (IASTNode)stmt, ExtractFunctionRefactoring.this.file)) {
                    container.add((IASTNode)stmt);
                    return 1;
                }
                return super.visit(stmt);
            }

            public int visit(IASTExpression expression) {
                if (SelectionHelper.isSelectedFile(ExtractFunctionRefactoring.this.region, (IASTNode)expression, ExtractFunctionRefactoring.this.file)) {
                    container.add((IASTNode)expression);
                    return 1;
                }
                return super.visit(expression);
            }
        });
        return container;
    }

    public List<IASTInitializerClause> getCallParameters() {
        ArrayList<IASTInitializerClause> args = new ArrayList<IASTInitializerClause>();
        Vector<IASTName> declarations = new Vector<IASTName>();
        for (NodeContainer.NameInformation nameInf : this.container.getNames()) {
            this.addAParameterIfPossible(args, declarations, nameInf);
        }
        return args;
    }

    private void addAParameterIfPossible(List<IASTInitializerClause> args, Vector<IASTName> declarations, NodeContainer.NameInformation nameInf) {
        IASTName declaration;
        if (!nameInf.isDeclarationInScope() && !declarations.contains(declaration = nameInf.getDeclaration())) {
            declarations.add(declaration);
            CPPASTIdExpression expression = new CPPASTIdExpression();
            expression.setName(this.newName(declaration));
            args.add((IASTInitializerClause)expression);
        }
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        ExtractFunctionRefactoringDescription desc = new ExtractFunctionRefactoringDescription(this.project.getProject().getName(), "Extract Method Refactoring", "Create method " + this.info.getMethodName(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.file.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.region.getOffset()) + "," + this.region.getLength());
        arguments.put("name", this.info.getMethodName());
        arguments.put("visibility", this.info.getVisibility().toString());
        arguments.put("replaceDuplicates", Boolean.toString(this.info.isReplaceDuplicates()));
        return arguments;
    }
}

