/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable;

import org.eclipse.cdt.internal.ui.refactoring.NameNVisibilityInformation;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.LabeledTextField;
import org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierResult;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InputPage
extends UserInputWizardPage {
    private String label = Messages.VariableName;
    private final NameNVisibilityInformation info;
    private InputForm control;

    public InputPage(String name, NameNVisibilityInformation info) {
        super(name);
        this.info = info;
    }

    public String getVariableName() {
        return this.info.getName();
    }

    public void createControl(Composite parent) {
        this.control = new InputForm(parent, this.label);
        this.setTitle(this.getName());
        this.setMessage(Messages.EnterVariableName);
        this.setPageComplete(false);
        Text nameText = this.control.getVariableNameText();
        nameText.setText(this.info.getName());
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputPage.this.info.setName(InputPage.this.control.getVariableNameText().getText());
                InputPage.this.checkName();
            }
        });
        nameText.selectAll();
        this.checkName();
        this.setControl((Control)this.control);
    }

    private void verifyName(String name) {
        if (this.info.getUsedNames().contains(name)) {
            this.setErrorMessage(NLS.bind((String)Messages.NameAlreadyDefined, (Object)name));
            this.setPageComplete(false);
        }
    }

    private void checkName() {
        String methodName = this.control.getVariableNameText().getText();
        IdentifierResult result = IdentifierHelper.checkIdentifierName(methodName);
        if (result.isCorrect()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            this.verifyName(methodName);
        } else {
            this.setErrorMessage(NLS.bind((String)Messages.CheckName, (Object)result.getMessage()));
            this.setPageComplete(false);
        }
    }

    private static class InputForm
    extends Composite {
        LabeledTextField variableName;

        InputForm(Composite parent, String label) {
            super(parent, 0);
            FillLayout layout = new FillLayout(256);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.horizontalAlignment = 4;
            this.setLayoutData(gridData);
            this.setLayout((Layout)layout);
            this.variableName = new LabeledTextField(this, label, "");
        }

        Text getVariableNameText() {
            return this.variableName.getText();
        }
    }
}

