/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.dom.parser.AbstractCLikeLanguage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetterSetterNameGenerator {
    private static Set<String> generateGetterSettersPreferenceKeys = new HashSet<String>();

    static {
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.capitalization");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.wordDelimiter");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.prefixForBoolean");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.prefix");
        generateGetterSettersPreferenceKeys.add("nameStyle.getter.suffix");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.capitalization");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.wordDelimiter");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.prefix");
        generateGetterSettersPreferenceKeys.add("nameStyle.setter.suffix");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.capitalization");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.wordDelimiter");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.prefix");
        generateGetterSettersPreferenceKeys.add("nameStyle.variable.suffix");
    }

    private GetterSetterNameGenerator() {
    }

    public static Set<String> getGenerateGetterSettersPreferenceKeys() {
        return generateGetterSettersPreferenceKeys;
    }

    public static String generateGetterName(IASTName fieldName, Set<String> namesToAvoid) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.getter.capitalization", 3, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.wordDelimiter", "", null);
        String prefix = GetterSetterNameGenerator.isBooleanDeclaratorName(fieldName) ? preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.prefixForBoolean", "is", null) : preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.prefix", "get", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        String name = NameComposer.trimFieldName(fieldName.toString());
        name = composer.compose(name);
        return GetterSetterNameGenerator.adjustName(name, namesToAvoid);
    }

    private static boolean isBooleanDeclaratorName(IASTName name) {
        IASTDeclarator declarator;
        IType type;
        return IASTDeclarator.DECLARATOR_NAME.equals(name.getPropertyInParent()) && (type = CPPVisitor.createType((IASTDeclarator)(declarator = (IASTDeclarator)name.getParent()))) instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eBoolean;
    }

    public static String generateSetterName(IASTName fieldName, Set<String> namesToAvoid) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.setter.capitalization", 3, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.prefix", "set", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        String name = NameComposer.trimFieldName(fieldName.toString());
        name = composer.compose(name);
        return GetterSetterNameGenerator.adjustName(name, namesToAvoid);
    }

    public static String generateSetterParameterName(IASTName fieldName) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.variable.capitalization", 0, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        String name = NameComposer.trimFieldName(fieldName.toString());
        if (!CConventions.validateIdentifier((String)(name = composer.compose(name)), (AbstractCLikeLanguage)GPPLanguage.getDefault()).isOK()) {
            name = String.valueOf('_') + name;
        }
        return name;
    }

    private static String adjustName(String name, Set<String> namesToAvoid) {
        String originalName = name;
        int i = 1;
        while (i < 100) {
            if (!namesToAvoid.contains(name) && CConventions.validateIdentifier((String)name, (AbstractCLikeLanguage)GPPLanguage.getDefault()).isOK()) {
                return name;
            }
            name = String.valueOf(originalName) + i;
            ++i;
        }
        return null;
    }
}

