/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;

public class ParameterInfo {
    private IASTParameterDeclaration parameter;
    private boolean hasNewName;
    private String parameterName;

    public ParameterInfo(IASTParameterDeclaration parameter, String parameterName, boolean HasNewName) {
        this.parameter = parameter;
        this.hasNewName = HasNewName;
        this.parameterName = parameterName;
    }

    public boolean hasNewName() {
        return this.hasNewName;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValueNode() != null;
    }

    public String getTypeName() {
        return NameHelper.getTypeName(this.parameter);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String newName) {
        this.parameterName = newName;
    }

    public IASTParameterDeclaration getParameter() {
        return this.parameter;
    }

    public IASTName getNameNode() {
        return this.parameter.getDeclarator().getName();
    }

    public IASTName getNewNameNode() {
        return new CPPASTName(this.parameterName.toCharArray());
    }

    public IASTNode getDefaultValueNode() {
        return this.parameter.getDeclarator().getInitializer();
    }
}

