/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.jface.text.ITextSelection;

public class DeclaratorFinder {
    private IASTFunctionDeclarator foundDeclarator;

    public DeclaratorFinder(ITextSelection selection, IASTTranslationUnit unit) {
        this.foundDeclarator = this.findDeclaratorInSelection(selection, unit);
        if (this.foundDeclarator == null) {
            throw new NotSupportedException(Messages.DeclaratorFinder_NoDeclarator);
        }
        if (this.isPartOfAStatement((IASTNode)this.foundDeclarator)) {
            throw new NotSupportedException(Messages.DeclaratorFinder_NestedFunction);
        }
    }

    public IASTName getName() {
        return this.foundDeclarator.getName();
    }

    private IASTFunctionDeclarator findDeclaratorInSelection(ITextSelection selection, IASTTranslationUnit unit) {
        IASTNode firstNodeInsideSelection = unit.getNodeSelector(null).findFirstContainedNode(selection.getOffset(), selection.getLength());
        IASTFunctionDeclarator declarator = this.findDeclaratorInAncestors(firstNodeInsideSelection);
        if (declarator == null) {
            firstNodeInsideSelection = unit.getNodeSelector(null).findEnclosingNode(selection.getOffset(), selection.getLength());
            declarator = this.findDeclaratorInAncestors(firstNodeInsideSelection);
        }
        return declarator;
    }

    private IASTFunctionDeclarator findDeclaratorInAncestors(IASTNode node) {
        while (node != null) {
            IASTFunctionDeclarator declarator = this.extractDeclarator(node);
            if (node instanceof ICPPASTTemplateDeclaration) {
                declarator = this.extractDeclarator((IASTNode)((ICPPASTTemplateDeclaration)node).getDeclaration());
            }
            if (declarator != null) {
                return declarator;
            }
            node = node.getParent();
        }
        return null;
    }

    private IASTFunctionDeclarator extractDeclarator(IASTNode node) {
        if (node instanceof ICPPASTTemplateDeclaration) {
            node = ((ICPPASTTemplateDeclaration)node).getDeclaration();
        }
        if (node instanceof IASTFunctionDeclarator) {
            return (IASTFunctionDeclarator)node;
        }
        if (node instanceof IASTFunctionDefinition) {
            return ((IASTFunctionDefinition)node).getDeclarator();
        }
        if (node instanceof IASTSimpleDeclaration) {
            IASTDeclarator[] declarators = ((IASTSimpleDeclaration)node).getDeclarators();
            if (declarators.length > 1) {
                throw new NotSupportedException(Messages.DeclaratorFinder_MultipleDeclarators);
            }
            if (declarators.length == 1 && declarators[0] instanceof IASTFunctionDeclarator) {
                return (IASTFunctionDeclarator)declarators[0];
            }
        }
        return null;
    }

    private boolean isPartOfAStatement(IASTNode node) {
        return ToggleNodeHelper.getAncestorOfType(node, IASTStatement.class) != null;
    }
}

