/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class TranslationUnitHelper {
    private static final int AST_STYLE = 34;

    public static IASTName findNameInTranslationUnit(IASTTranslationUnit transUnit, IASTNode oldName) {
        final String oldFileName = oldName.getFileLocation().getFileName();
        final IASTFileLocation pos = oldName.getFileLocation();
        final Container nameCon = new Container();
        transUnit.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName locName) {
                IASTFileLocation locFileLocation = locName.getFileLocation();
                if (locFileLocation != null && oldFileName.equals(locFileLocation.getFileName()) && pos.getNodeOffset() == locFileLocation.getNodeOffset() && pos.getNodeLength() == locFileLocation.getNodeLength()) {
                    nameCon.setObject(locName);
                    return 2;
                }
                return super.visit(locName);
            }
        });
        return (IASTName)nameCon.getObject();
    }

    public static IASTNode getFirstNode(IASTTranslationUnit unit) {
        IASTDeclaration firstNode = null;
        IASTDeclaration[] iASTDeclarationArray = unit.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration each = iASTDeclarationArray[n2];
            if (firstNode == null) {
                firstNode = each;
            } else if (each.getNodeLocations() != null && each.getNodeLocations()[0].getNodeOffset() < firstNode.getNodeLocations()[0].getNodeOffset()) {
                firstNode = each;
            }
            ++n2;
        }
        return firstNode;
    }

    @Deprecated
    public static IASTTranslationUnit loadTranslationUnit(String filename, boolean useIndex) throws CoreException {
        if (filename != null) {
            IFile[] tmpFile = null;
            tmpFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((String)filename));
            return TranslationUnitHelper.loadTranslationUnit(tmpFile[0], useIndex);
        }
        return null;
    }

    @Deprecated
    public static IASTTranslationUnit loadTranslationUnit(IFile file, boolean useIndex) throws CoreException {
        if (file == null) {
            return null;
        }
        if (useIndex) {
            return TranslationUnitHelper.loadIndexBasedTranslationUnit(file);
        }
        return TranslationUnitHelper.loadFileBasedTranslationUnit(file);
    }

    private static IASTTranslationUnit loadFileBasedTranslationUnit(IFile file) {
        try {
            IASTTranslationUnit fileUnit = CDOM.getInstance().getTranslationUnit(file, CDOM.getInstance().getCodeReaderFactory(0), true);
            return fileUnit;
        }
        catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {
            return null;
        }
    }

    private static IASTTranslationUnit loadIndexBasedTranslationUnit(IFile file) throws CoreException {
        IIndex index = null;
        try {
            index = TranslationUnitHelper.lockIndex();
            ITranslationUnit tu = (ITranslationUnit)CCorePlugin.getDefault().getCoreModel().create(file);
            IASTTranslationUnit iASTTranslationUnit = tu.getAST(index, 34);
            return iASTTranslationUnit;
        }
        catch (InterruptedException e) {
            CUIPlugin.log(e);
        }
        finally {
            TranslationUnitHelper.unlockIndex(index);
        }
        return null;
    }

    private static IIndex lockIndex() throws CoreException, InterruptedException {
        ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
        try {
            index.acquireReadLock();
        }
        catch (InterruptedException e) {
            index = null;
            throw e;
        }
        return index;
    }

    private static void unlockIndex(IIndex index) {
        if (index != null) {
            index.releaseReadLock();
        }
    }
}

