/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InclusionProposalComputer
implements ICompletionProposalComputer {
    private String fErrorMessage;

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        CContentAssistInvocationContext cContext;
        List<ICompletionProposal> proposals = Collections.emptyList();
        this.fErrorMessage = null;
        if (context instanceof CContentAssistInvocationContext && this.inIncludeDirective(cContext = (CContentAssistInvocationContext)context)) {
            proposals = new ArrayList<ICompletionProposal>();
            try {
                this.addInclusionProposals(cContext, proposals);
            }
            catch (Exception exc) {
                this.fErrorMessage = exc.getMessage();
                CUIPlugin.log(exc);
            }
        }
        return proposals;
    }

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public void sessionEnded() {
    }

    @Override
    public void sessionStarted() {
    }

    private boolean inIncludeDirective(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            String ppPrefix;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType()) && (ppPrefix = doc.get(partition.getOffset(), offset - partition.getOffset())).matches("\\s*#\\s*include\\s*[\"<][^\">]*")) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private void addInclusionProposals(CContentAssistInvocationContext context, List<ICompletionProposal> proposals) throws Exception {
        Path prefixPath;
        String[] potentialIncludes;
        if (context.isContextInformationStyle()) {
            return;
        }
        ITranslationUnit tu = context.getTranslationUnit();
        if (tu == null) {
            return;
        }
        boolean angleBrackets = false;
        String prefix = this.computeIncludePrefix(context);
        if (prefix.length() > 0) {
            angleBrackets = prefix.charAt(0) == '<';
            prefix = prefix.substring(1);
        }
        if ((potentialIncludes = this.collectIncludeFiles(tu, (IPath)(prefixPath = new Path(prefix)), angleBrackets)).length > 0) {
            IInclude[] includes = tu.getIncludes();
            HashSet<String> alreadyIncluded = new HashSet<String>();
            IInclude[] iIncludeArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IInclude includeDirective = iIncludeArray[n2];
                alreadyIncluded.add(includeDirective.getElementName());
                ++n2;
            }
            Image image = this.getImage(CElementImageProvider.getIncludeImageDescriptor());
            String[] stringArray = potentialIncludes;
            int n3 = potentialIncludes.length;
            n = 0;
            while (n < n3) {
                String include = stringArray[n];
                if (alreadyIncluded.add(include)) {
                    boolean needClosingBracket;
                    char openingBracket = angleBrackets ? (char)'<' : '\"';
                    char closingBracket = angleBrackets ? (char)'>' : '\"';
                    String repString = String.valueOf(openingBracket) + include;
                    String dispString = String.valueOf(repString) + closingBracket;
                    int repLength = prefix.length() + 1;
                    int repOffset = context.getInvocationOffset() - repLength;
                    boolean bl = needClosingBracket = context.getDocument().getChar(repOffset + repLength) != closingBracket;
                    if (needClosingBracket) {
                        repString = String.valueOf(repString) + closingBracket;
                    }
                    boolean isDir = include.endsWith("/");
                    int relevance = this.computeRelevance(prefix, include) + (isDir ? 0 : 1);
                    CCompletionProposal proposal = this.createProposal(repOffset, repLength, repString, dispString, image, relevance, context);
                    if (!isDir && !needClosingBracket) {
                        proposal.setCursorPosition(repString.length() + 1);
                    }
                    proposals.add(proposal);
                }
                ++n;
            }
        }
    }

    private String[] collectIncludeFiles(ITranslationUnit tu, IPath prefixPath, boolean angleBrackets) throws CoreException {
        IScannerInfo info;
        ArrayList<String> includeFiles = new ArrayList<String>();
        if (!angleBrackets) {
            IResource resource = tu.getResource();
            if (resource != null) {
                IContainer parent = resource.getParent();
                this.collectIncludeFilesFromContainer(tu, parent, prefixPath, includeFiles);
            } else {
                IPath location = tu.getLocation();
                if (location != null) {
                    this.collectIncludeFilesFromDirectory(tu, location.removeLastSegments(1), prefixPath, includeFiles);
                }
            }
        }
        if ((info = tu.getScannerInfo(true)) != null) {
            this.collectIncludeFilesFromScannerInfo(tu, info, prefixPath, angleBrackets, includeFiles);
        }
        return includeFiles.toArray(new String[includeFiles.size()]);
    }

    private void collectIncludeFilesFromScannerInfo(ITranslationUnit tu, IScannerInfo info, IPath prefixPath, boolean angleBrackets, List<String> includeFiles) {
        String[] allIncludes;
        int n;
        IExtendedScannerInfo extendedInfo;
        String[] quoteIncludes;
        if (!angleBrackets && info instanceof IExtendedScannerInfo && (quoteIncludes = (extendedInfo = (IExtendedScannerInfo)info).getLocalIncludePath()) != null) {
            String[] stringArray = quoteIncludes;
            int n2 = quoteIncludes.length;
            n = 0;
            while (n < n2) {
                String quoteInclude = stringArray[n];
                Path includeDir = new Path(quoteInclude);
                this.collectIncludeFilesFromDirectory(tu, (IPath)includeDir, prefixPath, includeFiles);
                ++n;
            }
        }
        String[] stringArray = allIncludes = info.getIncludePaths();
        n = allIncludes.length;
        int n3 = 0;
        while (n3 < n) {
            String allInclude = stringArray[n3];
            Path includeDir = new Path(allInclude);
            this.collectIncludeFilesFromDirectory(tu, (IPath)includeDir, prefixPath, includeFiles);
            ++n3;
        }
    }

    private void collectIncludeFilesFromDirectory(ITranslationUnit tu, IPath directory, IPath prefixPath, List<String> includeFiles) {
        String namePrefix;
        if (prefixPath.segmentCount() == 0) {
            namePrefix = "";
        } else if (prefixPath.hasTrailingSeparator()) {
            namePrefix = "";
            prefixPath = prefixPath.removeTrailingSeparator();
            directory = directory.append(prefixPath);
        } else {
            namePrefix = prefixPath.lastSegment();
            if ((prefixPath = prefixPath.removeLastSegments(1)).segmentCount() > 0) {
                directory = directory.append(prefixPath);
            }
        }
        File fileDir = directory.toFile();
        if (!fileDir.exists()) {
            return;
        }
        int prefixLength = namePrefix.length();
        IProject project = tu.getCProject().getProject();
        File[] files = fileDir.listFiles();
        if (files == null) {
            return;
        }
        IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(namePrefix);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (name.length() >= prefixLength && matcher.match(name.toCharArray())) {
                if (file.isFile()) {
                    if (CoreModel.isValidCXXHeaderUnitName((IProject)project, (String)name) || CoreModel.isValidCHeaderUnitName((IProject)project, (String)name)) {
                        includeFiles.add(prefixPath.append(name).toString());
                    }
                } else if (file.isDirectory()) {
                    includeFiles.add(prefixPath.append(name).addTrailingSeparator().toString());
                }
            }
            ++n2;
        }
    }

    private void collectIncludeFilesFromContainer(ITranslationUnit tu, IContainer parent, IPath prefixPath, final List<String> includeFiles) throws CoreException {
        String namePrefix;
        if (prefixPath.segmentCount() == 0) {
            namePrefix = "";
        } else if (prefixPath.hasTrailingSeparator()) {
            namePrefix = "";
            prefixPath = prefixPath.removeTrailingSeparator();
        } else {
            namePrefix = prefixPath.lastSegment();
            prefixPath = prefixPath.removeLastSegments(1);
        }
        if (prefixPath.segmentCount() > 0) {
            IPath parentPath = parent.getFullPath().append(prefixPath);
            if (parentPath.segmentCount() > 1) {
                parent = parent.getFolder(prefixPath);
            } else if (parentPath.segmentCount() == 1) {
                parent = ResourcesPlugin.getWorkspace().getRoot().getProject(parentPath.lastSegment());
            } else {
                return;
            }
        }
        if (!parent.exists()) {
            return;
        }
        final IPath cPrefixPath = prefixPath;
        final int prefixLength = namePrefix.length();
        final IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(namePrefix);
        final IProject project = tu.getCProject().getProject();
        parent.accept(new IResourceProxyVisitor(){
            boolean fFirstVisit = true;

            public boolean visit(IResourceProxy proxy) throws CoreException {
                int type = proxy.getType();
                String name = proxy.getName();
                if (this.fFirstVisit) {
                    this.fFirstVisit = false;
                    return true;
                }
                if (name.length() >= prefixLength && matcher.match(name.toCharArray())) {
                    if (type == 1) {
                        if (CoreModel.isValidCXXHeaderUnitName((IProject)project, (String)name) || CoreModel.isValidCHeaderUnitName((IProject)project, (String)name)) {
                            includeFiles.add(cPrefixPath.append(name).toString());
                        }
                    } else if (type == 2) {
                        includeFiles.add(cPrefixPath.append(name).addTrailingSeparator().toString());
                    }
                }
                return false;
            }
        }, 1);
    }

    private String computeIncludePrefix(CContentAssistInvocationContext context) throws BadLocationException {
        int end;
        IDocument document = context.getDocument();
        if (document == null) {
            return null;
        }
        int start = end = context.getInvocationOffset();
        while (--start >= 0) {
            char ch = document.getChar(start);
            if (ch == '\"' || ch == '<') break;
        }
        return document.get(start, end - start);
    }

    protected int computeRelevance(String prefix, String match) {
        boolean caseMatch;
        int baseRelevance = 0;
        boolean bl = caseMatch = prefix.length() > 0 && match.startsWith(prefix);
        if (caseMatch) {
            baseRelevance += 1000;
        }
        return baseRelevance;
    }

    private CCompletionProposal createProposal(int repOffset, int repLength, String repString, String dispString, Image image, int relevance, CContentAssistInvocationContext context) {
        return new CCompletionProposal(repString, repOffset, repLength, image, dispString, dispString, relevance, context.getViewer());
    }

    private Image getImage(ImageDescriptor desc) {
        return desc != null ? CUIPlugin.getImageDescriptorRegistry().get(desc) : null;
    }
}

