/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction.proposals;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.EditorHighlightingSynchronizer;
import org.eclipse.cdt.internal.ui.search.LinkedNamesFinder;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.cdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.cdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LinkedNamesAssistProposal
implements ICCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension6,
ICommandAccess {
    public static final String ASSIST_ID = "org.eclipse.cdt.ui.correction.renameInFile.assist";
    private ITranslationUnit fTranslationUnit;
    private String fLabel;
    private String fValueSuggestion;
    private int fRelevance;
    private IRegion[] fLocations;

    public LinkedNamesAssistProposal(ITranslationUnit tu) {
        this(CorrectionMessages.LinkedNamesAssistProposal_description, tu, null);
        this.fTranslationUnit = tu;
        this.fRelevance = 8;
    }

    public LinkedNamesAssistProposal(String label, ITranslationUnit tu, String valueSuggestion) {
        this.fLabel = label;
        this.fTranslationUnit = tu;
        this.fValueSuggestion = valueSuggestion;
        this.fRelevance = 8;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, final int offset) {
        try {
            this.fLocations = null;
            Point selection = viewer.getSelectedRange();
            final int secectionOffset = selection.x;
            final int selectionLength = selection.y;
            ASTProvider.getASTProvider().runOnAST((ICElement)this.fTranslationUnit, ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor(), new ASTCache.ASTRunnable(){

                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) throws CoreException {
                    if (astRoot == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IASTNodeSelector selector = astRoot.getNodeSelector(null);
                    IASTName name = selector.findEnclosingName(secectionOffset, selectionLength);
                    if (name != null) {
                        LinkedNamesAssistProposal.this.fLocations = LinkedNamesFinder.findByName(astRoot, name);
                    }
                    return Status.OK_STATUS;
                }
            });
            if (this.fLocations == null || this.fLocations.length == 0) {
                return;
            }
            Arrays.sort(this.fLocations, new Comparator<IRegion>(){

                @Override
                public int compare(IRegion n1, IRegion n2) {
                    return this.rank(n1) - this.rank(n2);
                }

                private int rank(IRegion location) {
                    int relativeRank = location.getOffset() + location.getLength() - offset;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            IDocument document = viewer.getDocument();
            LinkedPositionGroup group = new LinkedPositionGroup();
            int i = 0;
            while (i < this.fLocations.length) {
                IRegion item = this.fLocations[i];
                group.addPosition(new LinkedPosition(document, item.getOffset(), item.getLength(), i));
                ++i;
            }
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            CEditor editor = this.getCEditor();
            if (editor != null) {
                model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new DeleteBlockingExitPolicy(document));
            ui.setExitPosition(viewer, offset, 0, -1);
            ui.enter();
            if (this.fValueSuggestion != null) {
                document.replace(this.fLocations[0].getOffset(), this.fLocations[0].getLength(), this.fValueSuggestion);
                IRegion selectedRegion = ui.getSelectedRegion();
                selection = new Point(selectedRegion.getOffset(), this.fValueSuggestion.length());
            }
            viewer.setSelectedRange(selection.x, selection.y);
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
    }

    private CEditor getCEditor() {
        IEditorPart part = CUIPlugin.getActivePage().getActiveEditor();
        if (part instanceof CEditor) {
            return (CEditor)part;
        }
        return null;
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.LinkedNamesAssistProposal_proposalinfo;
    }

    public String getDisplayString() {
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            return NLS.bind((String)CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, (Object)this.fLabel, (Object)shortCutString);
        }
        return this.fLabel;
    }

    public StyledString getStyledDisplayString() {
        StyledString str = new StyledString(this.fLabel);
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            String decorated = NLS.bind((String)CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, (Object)this.fLabel, (Object)shortCutString);
            return ColoringLabelProvider.decorateStyledString(str, decorated, StyledString.QUALIFIER_STYLER);
        }
        return str;
    }

    public Image getImage() {
        return CDTSharedImages.getImage("icons/obj16/correction_linked_rename.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void selected(ITextViewer textViewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer textViewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    public String getCommandId() {
        return ASSIST_ID;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public String getIdString() {
        return ASSIST_ID;
    }

    public static class DeleteBlockingExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private IDocument fDocument;

        public DeleteBlockingExitPolicy(IDocument document) {
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            LinkedPosition position;
            if (length == 0 && (event.character == '\b' || event.character == '\u007f') && (position = model.findPosition(new LinkedPosition(this.fDocument, offset, 0, -1))) != null) {
                if (event.character == '\b') {
                    if (offset - 1 < position.getOffset()) {
                        event.doit = false;
                    }
                } else if (offset + 1 > position.getOffset() + position.getLength()) {
                    event.doit = false;
                }
            }
            return null;
        }
    }
}

