/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingPreferences;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.cdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WordCompletionProposalComputer
implements ICompletionProposalComputer {
    private static final int PREFIX_RANK_SHIFT = 500;

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (this.contributes()) {
            try {
                ISpellCheckEngine engine;
                ISpellChecker checker;
                IDocument document = context.getDocument();
                final int offset = context.getInvocationOffset();
                IRegion region = document.getLineInformationOfOffset(offset);
                String content = document.get(region.getOffset(), region.getLength());
                int index = offset - region.getOffset() - 1;
                while (index >= 0 && Character.isLetter(content.charAt(index))) {
                    --index;
                }
                int start = region.getOffset() + index + 1;
                String candidate = content.substring(index + 1, offset - region.getOffset());
                if (candidate.length() > 0 && (checker = (engine = SpellCheckEngine.getInstance()).getSpellChecker()) != null) {
                    ArrayList<RankedWordProposal> proposals = new ArrayList<RankedWordProposal>(checker.getProposals(candidate, Character.isUpperCase(candidate.charAt(0))));
                    ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>(proposals.size());
                    for (Object e : proposals) {
                        RankedWordProposal word = (RankedWordProposal)e;
                        String text = word.getText();
                        if (text.startsWith(candidate)) {
                            word.setRank(word.getRank() + 500);
                        }
                        result.add(new CCompletionProposal(text, start, candidate.length(), CDTSharedImages.getImage("icons/obj16/correction_rename.gif"), text, word.getRank()){

                            public boolean validate(IDocument doc, int validate_offset, DocumentEvent event) {
                                return offset == validate_offset;
                            }
                        });
                    }
                    return result;
                }
            }
            catch (BadLocationException exception) {
                CUIPlugin.log(exception);
            }
        }
        return Collections.emptyList();
    }

    private boolean contributes() {
        return SpellingPreferences.isEnabledSpellingContentAssist();
    }

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
    }
}

