/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.util.CHelpDisplayContext;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.ui.texteditor.ITextEditor;

public class CUIHelp {
    public static void setHelp(CEditor editor, StyledText text, String contextId) {
        CUIHelpListener listener = new CUIHelpListener(editor, contextId);
        text.addHelpListener((HelpListener)listener);
    }

    public static final class CUIHelpContextProvider
    implements IContextProvider {
        private final ITextEditor fEditor;

        public CUIHelpContextProvider(ITextEditor editor) {
            this.fEditor = editor;
        }

        public IContext getContext(Object target) {
            String selected = CUIHelpContextProvider.getSelectedString(this.fEditor);
            IContext context = HelpSystem.getContext((String)"org.eclipse.cdt.ui.editor_view");
            if (context != null && selected != null && selected.length() > 0) {
                try {
                    context = new CHelpDisplayContext(context, this.fEditor, selected);
                }
                catch (CoreException coreException) {}
            }
            return context;
        }

        public int getContextChangeMask() {
            return 1;
        }

        public String getSearchExpression(Object target) {
            return CUIHelpContextProvider.getSelectedString(this.fEditor);
        }

        private static String getSelectedString(ITextEditor editor) {
            String expression = null;
            try {
                ITextSelection selection = (ITextSelection)editor.getSite().getSelectionProvider().getSelection();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                IRegion region = CWordFinder.findWord(document, selection.getOffset());
                if (region != null) {
                    expression = document.get(region.getOffset(), region.getLength());
                }
            }
            catch (Exception exception) {}
            return expression;
        }
    }

    private static class CUIHelpListener
    implements HelpListener {
        private String fContextId;
        private CEditor fEditor;

        public CUIHelpListener(CEditor editor, String contextId) {
            this.fContextId = contextId;
            this.fEditor = editor;
        }

        public void helpRequested(HelpEvent e) {
            try {
                CHelpDisplayContext.displayHelp(this.fContextId, (ITextEditor)this.fEditor);
            }
            catch (CoreException x) {
                CUIPlugin.log(x);
            }
        }
    }
}

