/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.net.URI;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInputFactory;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ide.FileStoreEditorInput;

public final class ExternalEditorInput
extends FileStoreEditorInput
implements ITranslationUnitEditorInput {
    private final IPath location;
    private final IResource markerResource;
    private ITranslationUnit unit;

    public ExternalEditorInput(ITranslationUnit unit) {
        this(unit.getLocationURI(), (IResource)unit.getCProject().getProject());
        Assert.isNotNull((Object)unit);
        this.unit = unit;
    }

    public ExternalEditorInput(IPath location) {
        this(URIUtil.toURI((IPath)location), null);
    }

    public ExternalEditorInput(IPath location, IResource markerResource) {
        this(URIUtil.toURI((IPath)location), markerResource);
    }

    public ExternalEditorInput(URI locationURI) {
        this(locationURI, null);
    }

    public ExternalEditorInput(URI locationURI, IResource markerResource) {
        super(ExternalEditorInput.getFileStore(locationURI));
        this.location = URIUtil.toPath((URI)locationURI);
        this.markerResource = markerResource;
    }

    private static IFileStore getFileStore(URI locationURI) {
        try {
            return EFS.getStore((URI)locationURI);
        }
        catch (CoreException exc) {
            CUIPlugin.log(exc);
            return null;
        }
    }

    public ITranslationUnit getTranslationUnit() {
        return this.unit;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITranslationUnit.class) && this.unit != null) {
            return this.unit;
        }
        return super.getAdapter(adapter);
    }

    public IResource getMarkerResource() {
        return this.markerResource;
    }

    public String getFactoryId() {
        if (this.getPath() != null) {
            return "org.eclipse.cdt.ui.ExternalEditorInputFactory";
        }
        return super.getFactoryId();
    }

    public void saveState(IMemento memento) {
        if (this.getPath() != null) {
            ExternalEditorInputFactory.saveState(memento, this);
        } else {
            super.saveState(memento);
        }
    }

    public IPath getPath() {
        return this.location;
    }
}

