/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    private static final String KEY_SRC = "isSource";
    private static final String KEY_PAGE = "pageEnabled";
    private static final String VAL_EXP = "export";
    private static final String VAL_TOOL = "toolEdit";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (KEY_SRC.equals(property)) {
            if (receiver instanceof ITranslationUnit) {
                return ((ITranslationUnit)receiver).isSourceUnit();
            }
            if (receiver instanceof IFile) {
                IFile file = (IFile)receiver;
                return CoreModel.isValidSourceUnitName((IProject)file.getProject(), (String)file.getName());
            }
        } else if (KEY_PAGE.equals(property) && expectedValue instanceof String) {
            String s = (String)expectedValue;
            if (VAL_EXP.equalsIgnoreCase(s)) {
                return CDTPrefUtil.getBool("properties.export.page.enable");
            }
            if (VAL_TOOL.equalsIgnoreCase(s)) {
                return !CDTPrefUtil.getBool("properties.toolchain.modification.disable");
            }
        }
        return false;
    }
}

