/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadataFactory {
    protected static final String LIST_SEPARATOR = " ";

    protected void encodeString(IServiceProperties props, String name, String value) {
        props.setPropertyString(name, value);
    }

    protected String decodeString(IServiceProperties props, String name) {
        return props.getPropertyString(name);
    }

    protected void encodeLong(IServiceProperties result, String name, Long value) {
        result.setPropertyString(name, value.toString());
    }

    protected Long decodeLong(IServiceProperties props, String name) {
        String longAsString = props.getPropertyString(name);
        if (longAsString == null) {
            return new Long(0L);
        }
        return new Long(longAsString);
    }

    protected void encodeList(IServiceProperties props, String name, List<String> list) {
        if (list == null) {
            return;
        }
        if (list.size() == 1) {
            props.setPropertyString(name, list.get(0));
        } else {
            StringBuffer result = new StringBuffer();
            Iterator<String> i = list.iterator();
            while (i.hasNext()) {
                result.append(i.next());
                if (!i.hasNext()) continue;
                result.append(LIST_SEPARATOR);
            }
            props.setPropertyString(name, result.toString());
        }
    }

    protected List<String> decodeList(IServiceProperties props, String name) {
        String value = props.getPropertyString(name);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(value, LIST_SEPARATOR);
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    protected void decodeOSGiProperties(IServiceProperties props, Map osgiProperties) {
        List<String> remoteIntentsSupported;
        List<String> remoteConfigsSupported;
        List<String> intents;
        List<String> interfaces = this.decodeList(props, "objectClass");
        osgiProperties.put("objectClass", interfaces.toArray(new String[interfaces.size()]));
        for (String intf : interfaces) {
            String packageKey = "endpoint.package.version." + this.getPackageName(intf);
            String intfVersion = this.decodeString(props, packageKey);
            if (intfVersion == null) continue;
            osgiProperties.put(packageKey, intfVersion);
        }
        String endpointId = this.decodeString(props, "endpoint.id");
        osgiProperties.put("endpoint.id", endpointId);
        Long endpointServiceId = this.decodeLong(props, "endpoint.service.id");
        osgiProperties.put("endpoint.service.id", endpointServiceId);
        String fwkuuid = this.decodeString(props, "endpoint.framework.uuid");
        osgiProperties.put("endpoint.framework.uuid", fwkuuid);
        List<String> configTypes = this.decodeList(props, "service.imported.configs");
        if (configTypes != null && configTypes.size() > 0) {
            osgiProperties.put("service.imported.configs", configTypes.toArray(new String[configTypes.size()]));
        }
        if ((intents = this.decodeList(props, "service.intents")) != null && intents.size() > 0) {
            osgiProperties.put("service.intents", intents.toArray(new String[intents.size()]));
        }
        if ((remoteConfigsSupported = this.decodeList(props, "remote.configs.supported")) != null && remoteConfigsSupported.size() > 0) {
            osgiProperties.put("remote.configs.supported", remoteConfigsSupported.toArray(new String[remoteConfigsSupported.size()]));
        }
        if ((remoteIntentsSupported = this.decodeList(props, "remote.intents.supported")) != null && remoteIntentsSupported.size() > 0) {
            osgiProperties.put("remote.intents.supported", remoteIntentsSupported.toArray(new String[remoteIntentsSupported.size()]));
        }
    }

    protected EndpointDescription decodeEndpointDescription(IServiceProperties discoveredServiceProperties) {
        String remoteServiceFilter;
        List<String> idFilterNames;
        Object idFilterNamesval;
        String connectTargetIDName;
        TreeMap<String, Object> endpointDescriptionProperties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.decodeOSGiProperties(discoveredServiceProperties, endpointDescriptionProperties);
        Long remoteServiceId = this.decodeLong(discoveredServiceProperties, "ecf.rsvc.id");
        endpointDescriptionProperties.put("ecf.rsvc.id", remoteServiceId);
        String containerIDNamespace = this.decodeString(discoveredServiceProperties, "ecf.endpoint.id.ns");
        if (containerIDNamespace != null) {
            endpointDescriptionProperties.put("ecf.endpoint.id.ns", containerIDNamespace);
        }
        if ((connectTargetIDName = this.decodeString(discoveredServiceProperties, "ecf.endpoint.connecttarget.id")) != null) {
            endpointDescriptionProperties.put("ecf.endpoint.connecttarget.id", connectTargetIDName);
        }
        if ((idFilterNamesval = PropertiesUtil.convertToStringPlusValue(idFilterNames = this.decodeList(discoveredServiceProperties, "ecf.endpoint.idfilter.ids"))) != null) {
            endpointDescriptionProperties.put("ecf.endpoint.idfilter.ids", idFilterNamesval);
        }
        if ((remoteServiceFilter = this.decodeString(discoveredServiceProperties, "ecf.endpoint.rsfilter")) != null) {
            endpointDescriptionProperties.put("ecf.endpoint.rsfilter", remoteServiceFilter);
        }
        this.decodeNonStandardServiceProperties(discoveredServiceProperties, endpointDescriptionProperties);
        return new EndpointDescription(endpointDescriptionProperties);
    }

    private String getPackageName(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return className.substring(0, lastDotIndex);
    }

    protected void encodeOSGiServiceProperties(EndpointDescription endpointDescription, IServiceProperties result) {
        List remoteIntentsSupported;
        Map<String, Object> endpointDescriptionProperties;
        List remoteConfigsSupported;
        List serviceIntents;
        List configurationTypes;
        List interfaces = endpointDescription.getInterfaces();
        this.encodeList(result, "objectClass", interfaces);
        for (String intf : interfaces) {
            String intfPackageName = this.getPackageName(intf);
            Version intfVersion = endpointDescription.getPackageVersion(intfPackageName);
            if (intfVersion == null || Version.emptyVersion.equals((Object)intfVersion)) continue;
            this.encodeString(result, "endpoint.package.version." + intfPackageName, intfVersion.toString());
        }
        String endpointId = endpointDescription.getId();
        this.encodeString(result, "endpoint.id", endpointId);
        long endpointServiceId = endpointDescription.getServiceId();
        this.encodeLong(result, "endpoint.service.id", new Long(endpointServiceId));
        String frameworkUUID = endpointDescription.getFrameworkUUID();
        if (frameworkUUID != null) {
            this.encodeString(result, "endpoint.framework.uuid", frameworkUUID);
        }
        if ((configurationTypes = endpointDescription.getConfigurationTypes()).size() > 0) {
            this.encodeList(result, "service.imported.configs", configurationTypes);
        }
        if ((serviceIntents = endpointDescription.getIntents()).size() > 0) {
            this.encodeList(result, "service.intents", serviceIntents);
        }
        if ((remoteConfigsSupported = PropertiesUtil.getStringPlusProperty(endpointDescriptionProperties = endpointDescription.getProperties(), "remote.configs.supported")).size() > 0) {
            this.encodeList(result, "remote.configs.supported", remoteConfigsSupported);
        }
        if ((remoteIntentsSupported = PropertiesUtil.getStringPlusProperty(endpointDescriptionProperties, "remote.intents.supported")).size() > 0) {
            this.encodeList(result, "remote.intents.supported", remoteIntentsSupported);
        }
    }

    protected void encodeServiceProperties(EndpointDescription endpointDescription, IServiceProperties result) {
        String remoteFilter;
        ID[] idFilter;
        ID connectTargetID;
        String containerIDNamespace;
        this.encodeOSGiServiceProperties(endpointDescription, result);
        Long rsId = (Long)endpointDescription.getProperties().get("ecf.rsvc.id");
        if (rsId != null) {
            this.encodeLong(result, "ecf.rsvc.id", rsId);
        }
        if ((containerIDNamespace = endpointDescription.getIdNamespace()) != null) {
            this.encodeString(result, "ecf.endpoint.id.ns", containerIDNamespace);
        }
        if ((connectTargetID = endpointDescription.getConnectTargetID()) != null) {
            this.encodeString(result, "ecf.endpoint.connecttarget.id", connectTargetID.getName());
        }
        if ((idFilter = endpointDescription.getIDFilter()) != null && idFilter.length > 0) {
            ArrayList<String> idNames = new ArrayList<String>();
            int i = 0;
            while (i < idFilter.length) {
                idNames.add(idFilter[i].getName());
                ++i;
            }
            this.encodeList(result, "ecf.endpoint.idfilter.ids", idNames);
        }
        if ((remoteFilter = endpointDescription.getRemoteServiceFilter()) != null) {
            this.encodeString(result, "ecf.endpoint.rsfilter", remoteFilter);
        }
        this.encodeNonStandardServiceProperties(endpointDescription.getProperties(), result);
    }

    protected void encodeNonStandardServiceProperties(Map<String, Object> properties, IServiceProperties result) {
        for (String key : properties.keySet()) {
            if (PropertiesUtil.isReservedProperty(key)) continue;
            Object val = properties.get(key);
            if (val instanceof byte[]) {
                result.setPropertyBytes(key, (byte[])val);
                continue;
            }
            if (val instanceof String) {
                result.setPropertyString(key, (String)val);
                continue;
            }
            result.setProperty(key, val);
        }
    }

    protected void decodeNonStandardServiceProperties(IServiceProperties props, Map<String, Object> result) {
        Enumeration keys = props.getPropertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (PropertiesUtil.isReservedProperty(key)) continue;
            byte[] bytes = props.getPropertyBytes(key);
            if (bytes != null) {
                result.put(key, bytes);
                continue;
            }
            String str = props.getPropertyString(key);
            if (str != null) {
                result.put(key, str);
                continue;
            }
            Object obj = props.getProperty(key);
            if (obj == null) continue;
            result.put(key, obj);
        }
    }

    protected void logWarning(String methodName, String message, Throwable t) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/metadatafactory", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/metadatafactory", this.getClass(), message, t);
    }

    public void close() {
    }
}

