/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionAdvertiser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTopologyManager {
    public static final String SERVICE_EXPORTED_INTERFACES_WILDCARD = "*";
    private BundleContext context;
    private ServiceTracker endpointDescriptionAdvertiserTracker;
    private Object endpointDescriptionAdvertiserTrackerLock = new Object();
    private ServiceTracker remoteServiceAdminTracker;
    private Object remoteServiceAdminTrackerLock = new Object();
    protected Collection<ExportRegistration> exportedRegistrations = new ArrayList<ExportRegistration>();
    protected Collection<ImportRegistration> importedRegistrations = new ArrayList<ImportRegistration>();

    public AbstractTopologyManager(BundleContext context) {
        this.context = context;
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected String getFrameworkUUID() {
        Activator a = Activator.getDefault();
        if (a == null) {
            return null;
        }
        return a.getFrameworkUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEndpointDescriptionAdvertiser getEndpointDescriptionAdvertiser(EndpointDescription endpointDescription) {
        Object object = this.endpointDescriptionAdvertiserTrackerLock;
        synchronized (object) {
            if (this.endpointDescriptionAdvertiserTracker == null) {
                this.endpointDescriptionAdvertiserTracker = new ServiceTracker(this.getContext(), IEndpointDescriptionAdvertiser.class.getName(), null);
                this.endpointDescriptionAdvertiserTracker.open();
            }
        }
        return (IEndpointDescriptionAdvertiser)this.endpointDescriptionAdvertiserTracker.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Collection<ExportRegistration> collection = this.endpointDescriptionAdvertiserTrackerLock;
        synchronized (collection) {
            if (this.endpointDescriptionAdvertiserTracker != null) {
                this.endpointDescriptionAdvertiserTracker.close();
                this.endpointDescriptionAdvertiserTracker = null;
            }
        }
        collection = this.remoteServiceAdminTrackerLock;
        synchronized (collection) {
            if (this.remoteServiceAdminTracker != null) {
                this.remoteServiceAdminTracker.close();
                this.remoteServiceAdminTracker = null;
            }
        }
        collection = this.exportedRegistrations;
        synchronized (collection) {
            this.exportedRegistrations.clear();
        }
        collection = this.importedRegistrations;
        synchronized (collection) {
            this.importedRegistrations.clear();
        }
        this.context = null;
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected Filter createRSAFilter() {
        String filterString = "(&(objectClass=" + RemoteServiceAdmin.class.getName() + ")(" + "org.eclipse.ecf.rsa" + "=*))";
        try {
            return this.getContext().createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteServiceAdmin getRemoteServiceAdmin() {
        Object object = this.remoteServiceAdminTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminTracker == null) {
                this.remoteServiceAdminTracker = new ServiceTracker(this.getContext(), this.createRSAFilter(), null);
                this.remoteServiceAdminTracker.open();
            }
        }
        return (RemoteServiceAdmin)this.remoteServiceAdminTracker.getService();
    }

    protected void advertiseEndpointDescription(EndpointDescription endpointDescription) {
        IEndpointDescriptionAdvertiser advertiser = this.getEndpointDescriptionAdvertiser(endpointDescription);
        if (advertiser == null) {
            this.logWarning("advertiseExportedRegistration", "No endpoint description advertiser available for endpointDescription=" + (Object)((Object)endpointDescription));
            return;
        }
        this.trace("advertiseEndpointDescription", "advertising endpointDescription=" + (Object)((Object)endpointDescription) + " with advertiser=" + advertiser);
        IStatus result = advertiser.advertise(endpointDescription);
        if (!result.isOK()) {
            this.logError("advertiseExportedRegistration", "Advertise of endpointDescription=" + (Object)((Object)endpointDescription) + " FAILED", result);
        }
    }

    protected void unadvertiseEndpointDescription(EndpointDescription endpointDescription) {
        IEndpointDescriptionAdvertiser advertiser = this.getEndpointDescriptionAdvertiser(endpointDescription);
        if (advertiser == null) {
            this.logError("unadvertiseEndpointDescription", "No endpoint description advertiser available to unadvertise endpointDescription=" + (Object)((Object)endpointDescription));
            return;
        }
        IStatus result = advertiser.unadvertise(endpointDescription);
        if (!result.isOK()) {
            this.logError("unadvertiseEndpointDescription", "Unadvertise of endpointDescription=" + (Object)((Object)endpointDescription) + " FAILED", result);
        }
    }

    protected void logError(String methodName, String message, Throwable exception) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message, exception);
    }

    protected void logError(String methodName, String message, IStatus result) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), result);
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEndpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String matchedFilter) {
        RemoteServiceAdmin rsa = this.getRemoteServiceAdmin();
        if (rsa == null) {
            this.logError("handleEndpointAdded", "RemoteServiceAdmin not found for importing endpointDescription=" + endpointDescription);
            return;
        }
        this.trace("handleEndpointAdded", "endpointDescription=" + endpointDescription + " rsa=" + rsa);
        ImportRegistration importRegistration = rsa.importService(endpointDescription);
        if (importRegistration == null) {
            this.logError("handleEndpointAdded", "Import registration is null for endpointDescription=" + endpointDescription + " and rsa=" + rsa);
        } else {
            Throwable t = importRegistration.getException();
            if (t != null) {
                this.handleInvalidImportRegistration(importRegistration, t);
            } else {
                Collection<ImportRegistration> collection = this.importedRegistrations;
                synchronized (collection) {
                    this.importedRegistrations.add(importRegistration);
                }
            }
        }
    }

    protected void handleInvalidImportRegistration(ImportRegistration importRegistration, Throwable t) {
        this.logError("handleInvalidImportRegistration", "importRegistration=" + importRegistration, t);
    }

    protected void handleEvent(ServiceEvent event, Collection contexts) {
        switch (event.getType()) {
            case 2: {
                this.handleServiceModifying(event.getServiceReference());
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.handleServiceRegistering(event.getServiceReference());
                break;
            }
            case 4: {
                this.handleServiceUnregistering(event.getServiceReference());
                break;
            }
        }
    }

    protected void handleEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String matchedFilter) {
        this.trace("handleEndpointRemoved", "endpointDescription=" + endpointDescription);
        this.unimportService(endpointDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServiceRegistering(ServiceReference serviceReference) {
        String[] exportedInterfaces = PropertiesUtil.getExportedInterfaces(serviceReference);
        if (exportedInterfaces == null) {
            return;
        }
        RemoteServiceAdmin rsa = this.getRemoteServiceAdmin();
        if (rsa == null) {
            this.logError("handleServiceRegistered", "No RemoteServiceAdmin found for serviceReference=" + serviceReference + ".  Remote service NOT EXPORTED");
            return;
        }
        TreeMap<String, String[]> exportProperties = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        exportProperties.put("service.exported.interfaces", exportedInterfaces);
        this.trace("handleServiceRegistering", "serviceReference=" + serviceReference + " exportProperties=" + exportProperties);
        Collection registrations = rsa.exportService(serviceReference, exportProperties);
        if (registrations == null || registrations.size() == 0) {
            this.logError("handleServiceRegistered", "No export registrations created by RemoteServiceAdmin=" + rsa + ".  ServiceReference=" + serviceReference + " NOT EXPORTED");
            return;
        }
        ArrayList<EndpointDescription> endpointDescriptions = new ArrayList<EndpointDescription>();
        for (ExportRegistration exportRegistration : registrations) {
            Throwable t = exportRegistration.getException();
            if (t != null) {
                this.handleInvalidExportRegistration(exportRegistration, t);
                continue;
            }
            endpointDescriptions.add((EndpointDescription)exportRegistration.getExportReference().getExportedEndpoint());
            Collection<ExportRegistration> collection = this.exportedRegistrations;
            synchronized (collection) {
                this.exportedRegistrations.add(exportRegistration);
            }
        }
        this.advertiseEndpointDescriptions(endpointDescriptions);
    }

    protected void advertiseEndpointDescriptions(List<EndpointDescription> endpointDescriptions) {
        for (EndpointDescription ed : endpointDescriptions) {
            this.advertiseEndpointDescription(ed);
        }
    }

    protected void handleInvalidExportRegistration(ExportRegistration exportRegistration, Throwable t) {
        this.logError("handleInvalidExportRegistration", "exportRegistration=" + exportRegistration, t);
    }

    protected void handleServiceModifying(ServiceReference serviceReference) {
    }

    protected void handleServiceUnregistering(ServiceReference serviceReference) {
        Collection<EndpointDescription> endpointDescriptions = this.unexportService(serviceReference);
        if (endpointDescriptions != null) {
            for (EndpointDescription ed : endpointDescriptions) {
                this.unadvertiseEndpointDescription(ed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<EndpointDescription> unexportService(ServiceReference serviceReference) {
        HashMap<ExportRegistration, EndpointDescription> matchingExportRegistrations = null;
        Collection<ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            Iterator<ExportRegistration> i = this.exportedRegistrations.iterator();
            while (i.hasNext()) {
                ServiceReference exportReference;
                ExportReference exportRef;
                ExportRegistration exportRegistration;
                if (matchingExportRegistrations == null) {
                    matchingExportRegistrations = new HashMap<ExportRegistration, EndpointDescription>();
                }
                if ((exportRegistration = i.next()).getException() != null || (exportRef = exportRegistration.getExportReference()) == null || (exportReference = exportRef.getExportedService()) == null || !serviceReference.equals(exportReference)) continue;
                matchingExportRegistrations.put(exportRegistration, (EndpointDescription)exportRef.getExportedEndpoint());
                i.remove();
            }
        }
        if (matchingExportRegistrations == null || matchingExportRegistrations.size() == 0) {
            return null;
        }
        for (ExportRegistration exportRegistration : matchingExportRegistrations.keySet()) {
            this.trace("unexportService", "closing exportRegistration=" + exportRegistration);
            exportRegistration.close();
        }
        return matchingExportRegistrations.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unimportService(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        ArrayList<ImportRegistration> removedRegistrations = null;
        Collection<ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            Iterator<ImportRegistration> i = this.importedRegistrations.iterator();
            while (i.hasNext()) {
                org.osgi.service.remoteserviceadmin.EndpointDescription ed;
                ImportReference importRef;
                ImportRegistration importRegistration;
                if (removedRegistrations == null) {
                    removedRegistrations = new ArrayList<ImportRegistration>();
                }
                if ((importRegistration = i.next()).getException() != null || (importRef = importRegistration.getImportReference()) == null || (ed = importRef.getImportedEndpoint()) == null || !ed.isSameService(endpointDescription)) continue;
                removedRegistrations.add(importRegistration);
                i.remove();
            }
        }
        if (removedRegistrations != null) {
            for (ImportRegistration removedReg : removedRegistrations) {
                this.trace("unimportService", "closing importRegistration=" + removedReg);
                removedReg.close();
            }
        }
    }
}

