/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionAdvertiser;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescriptionAdvertiser
implements IEndpointDescriptionAdvertiser {
    private EndpointDescriptionLocator endpointDescriptionLocator;

    public EndpointDescriptionAdvertiser(EndpointDescriptionLocator endpointDescriptionLocator) {
        this.endpointDescriptionLocator = endpointDescriptionLocator;
    }

    @Override
    public IStatus advertise(EndpointDescription endpointDescription) {
        return this.doDiscovery(endpointDescription, true);
    }

    protected IStatus doDiscovery(IDiscoveryAdvertiser discoveryAdvertiser, IServiceInfo serviceInfo, boolean advertise) {
        try {
            if (advertise) {
                discoveryAdvertiser.registerService(serviceInfo);
            } else {
                discoveryAdvertiser.unregisterService(serviceInfo);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return this.createErrorStatus(String.valueOf(advertise ? "registerService" : "unregisterService") + " with serviceInfo=" + serviceInfo + " for discoveryAdvertiser=" + discoveryAdvertiser + " failed", e);
        }
    }

    protected IServiceInfoFactory getServiceInfoFactory() {
        return this.endpointDescriptionLocator.getServiceInfoFactory();
    }

    protected IDiscoveryAdvertiser[] getDiscoveryAdvertisers() {
        return this.endpointDescriptionLocator.getDiscoveryAdvertisers();
    }

    protected IStatus createErrorStatus(String message) {
        return this.createErrorStatus(message, null);
    }

    protected IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, "org.eclipse.ecf.osgi.services.remoteserviceadmin", message, e);
    }

    protected IStatus doDiscovery(EndpointDescription endpointDescription, boolean advertise) {
        Assert.isNotNull((Object)((Object)endpointDescription));
        String messagePrefix = advertise ? "Advertise" : "Unadvertise";
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        IServiceInfoFactory serviceInfoFactory = this.getServiceInfoFactory();
        if (serviceInfoFactory == null) {
            return this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + (Object)((Object)endpointDescription) + ".  No IServiceInfoFactory is available.  Cannot unpublish endpointDescription=" + (Object)((Object)endpointDescription));
        }
        IDiscoveryAdvertiser[] discoveryAdvertisers = this.getDiscoveryAdvertisers();
        if (discoveryAdvertisers == null || discoveryAdvertisers.length == 0) {
            return this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + (Object)((Object)endpointDescription) + ".  No endpointDescriptionLocator advertisers available.  Cannot " + (advertise ? "publish" : "unpublish") + " endpointDescription=" + (Object)((Object)endpointDescription));
        }
        int i = 0;
        while (i < discoveryAdvertisers.length) {
            IServiceInfo serviceInfo;
            IServiceInfo iServiceInfo = serviceInfo = advertise ? serviceInfoFactory.createServiceInfo(discoveryAdvertisers[i], endpointDescription) : serviceInfoFactory.removeServiceInfo(discoveryAdvertisers[i], endpointDescription);
            if (serviceInfo == null) {
                statuses.add(this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + (Object)((Object)endpointDescription) + ".  Service Info is null.  Cannot publish endpointDescription=" + (Object)((Object)endpointDescription)));
            } else {
                statuses.add(this.doDiscovery(discoveryAdvertisers[i], serviceInfo, advertise));
            }
            ++i;
        }
        return this.createResultStatus(statuses, String.valueOf(messagePrefix) + " endpointDesription=" + (Object)((Object)endpointDescription) + ".  Problem in unadvertise");
    }

    @Override
    public IStatus unadvertise(EndpointDescription endpointDescription) {
        return this.doDiscovery(endpointDescription, false);
    }

    private IStatus createResultStatus(List<IStatus> statuses, String errorMessage) {
        ArrayList<IStatus> errorStatuses = new ArrayList<IStatus>();
        for (IStatus status : statuses) {
            if (status.isOK()) continue;
            errorStatuses.add(status);
        }
        if (errorStatuses.size() > 0) {
            return new MultiStatus("org.eclipse.ecf.osgi.services.remoteserviceadmin", 4, statuses.toArray(new IStatus[statuses.size()]), errorMessage, null);
        }
        return Status.OK_STATUS;
    }

    public void close() {
        this.endpointDescriptionLocator = null;
    }
}

