/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.msn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.eclipse.ecf.protocol.msn.ChatSession;
import org.eclipse.ecf.protocol.msn.Contact;
import org.eclipse.ecf.protocol.msn.ContactList;
import org.eclipse.ecf.protocol.msn.DispatchSession;
import org.eclipse.ecf.protocol.msn.Group;
import org.eclipse.ecf.protocol.msn.MsnClient;
import org.eclipse.ecf.protocol.msn.Status;
import org.eclipse.ecf.protocol.msn.events.ISessionListener;
import org.eclipse.ecf.protocol.msn.internal.encode.Challenge;
import org.eclipse.ecf.protocol.msn.internal.encode.ResponseCommand;
import org.eclipse.ecf.protocol.msn.internal.encode.StringUtils;
import org.eclipse.ecf.protocol.msn.internal.net.ClientTicketRequest;

final class NotificationSession
extends DispatchSession {
    private final ContactList list;
    private ClientTicketRequest request;
    private ResponseCommand response;
    private Thread pingingThread;
    private String alternateServer;
    private String username;

    NotificationSession(MsnClient client) {
        super(client);
        this.list = client.getContactList();
        this.listeners = new ArrayList();
        this.request = new ClientTicketRequest();
    }

    boolean login(String userEmail, String password) throws IOException {
        this.response = this.connect(userEmail);
        if (this.response.getCommand().equals("USR")) {
            String ticket = this.request.getTicket(userEmail, password, this.response.getParam(3));
            password = null;
            if (ticket == null) {
                throw new ConnectException("Wrong username and/or password.");
            }
            this.write("USR", "TWN S " + ticket);
            ticket = null;
            String input = super.read();
            if (!input.startsWith("USR")) {
                throw new ConnectException("An error occurred while attempting to authenticate with the Tweener server.");
            }
            this.retrieveBuddyList();
            this.username = userEmail;
            return true;
        }
        if (!this.response.getCommand().equals("XFR")) {
            throw new ConnectException("Unable to connect to the MSN server.");
        }
        this.alternateServer = this.response.getParam(2);
        return false;
    }

    private void retrieveBuddyList() throws IOException {
        this.write("SYN", "0 0");
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF-8"));
        String input = reader.readLine();
        while (input == null || !input.startsWith("SYN")) {
            input = reader.readLine();
        }
        String[] split = StringUtils.splitOnSpace(input);
        int contacts = Integer.parseInt(split[4]);
        while (!input.startsWith("LST")) {
            if (input.startsWith("PRP MFN")) {
                this.client.internalSetDisplayName(StringUtils.splitSubstring(input, " ", 2));
            } else if (input.startsWith("LSG")) {
                split = StringUtils.splitOnSpace(input);
                this.list.addGroup(split[2], new Group(URLDecoder.decode(split[1])));
            }
            input = reader.readLine();
        }
        int count = 0;
        while (true) {
            if (input.startsWith("LST")) {
                ++count;
                String[] contact = StringUtils.splitOnSpace(input);
                String email = contact[1].substring(2);
                if (email.indexOf(64) != -1) {
                    switch (contact.length) {
                        case 3: {
                            this.list.internalAddContact(email, email);
                            break;
                        }
                        case 5: {
                            this.list.addContact(email, email, contact[3].substring(2));
                            break;
                        }
                        default: {
                            this.list.addContact(contact[2].substring(2), email, contact[3].substring(2), contact[5]);
                        }
                    }
                }
                if (count == contacts) break;
            }
            input = reader.readLine();
        }
        this.write("CHG", String.valueOf(this.client.getStatus().getLiteral()) + " 268435488");
        this.idle();
        this.ping();
    }

    private void processSwitchboardRequest(String[] data) throws IOException {
        ChatSession ss = new ChatSession(data[2], this.client);
        ss.write("ANS", String.valueOf(this.username) + ' ' + data[4] + ' ' + data[1]);
        ss.read();
        this.fireSwitchboardConnectedEvent(ss);
        ss.idle();
    }

    ResponseCommand getChatSession() throws IOException {
        if (this.client.getStatus() == Status.APPEAR_OFFLINE || this.client.getStatus() == Status.OFFLINE) {
            throw new ConnectException("Switchboards cannot be created when the user is hidden or offline.");
        }
        this.write("XFR", "SB");
        String command = this.response.getCommand();
        while (command == null || !command.equals("XFR")) {
            command = this.response.getCommand();
        }
        return this.response;
    }

    void reset() throws IOException {
        this.close();
        this.openSocket(this.alternateServer);
        this.request.setCancelled(false);
    }

    String read() throws IOException {
        String[] subSplit;
        String[] split;
        String[] split2;
        String[] sub;
        int i;
        String[] events;
        String input = super.read();
        if (input == null) {
            return null;
        }
        if (input.indexOf("ILN") != -1) {
            events = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < events.length) {
                if (!events[i].trim().equals("") && events[i].substring(1, 3).equals("LN")) {
                    sub = StringUtils.split(events[i], " ", 3);
                    split2 = StringUtils.splitOnSpace(sub[2]);
                    this.changeContactInfo(split2);
                }
                ++i;
            }
        } else if (input.indexOf("FLN") != -1) {
            events = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < events.length) {
                if (events[i].startsWith("FLN")) {
                    this.setContactToOffline(events[i]);
                }
                ++i;
            }
        } else if (input.indexOf("LN") != -1) {
            events = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < events.length) {
                if (events[i].substring(0, 3).equals("NLN")) {
                    sub = StringUtils.splitOnSpace(events[i].substring(4));
                    this.changeContactInfo(sub);
                } else if (events[i].substring(1, 3).equals("LN")) {
                    sub = StringUtils.split(events[i], " ", 3);
                    split2 = StringUtils.splitOnSpace(sub[2]);
                    this.changeContactInfo(split2);
                }
                ++i;
            }
        } else if (input.indexOf("CHL") != -1) {
            String query = Challenge.createQuery(StringUtils.splitSubstring(input, " ", 2));
            this.write("QRY", "PROD0090YUAUV{2B " + query.length() + "\r\n" + query, false);
        } else if (input.indexOf("RNG") != -1) {
            this.processSwitchboardRequest(StringUtils.splitOnSpace(input));
        }
        if (input.indexOf("XFR") != -1) {
            split = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < split.length) {
                if (split[i].startsWith("XFR")) {
                    this.response.process(split[i]);
                }
                ++i;
            }
        }
        if (input.indexOf("UBX") != -1) {
            split = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < split.length) {
                if (split[i].startsWith("UBX")) {
                    this.processContactData(split, i);
                }
                ++i;
            }
        }
        if (input.indexOf("ADC") != -1) {
            split = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < split.length) {
                if (split[i].startsWith("ADC")) {
                    subSplit = StringUtils.splitOnSpace(split[i]);
                    if (subSplit[2].equals("FL")) {
                        this.processContactAdded(subSplit[3].substring(2), subSplit[4].substring(2), subSplit[5].substring(2));
                    } else if (subSplit[2].equals("RL")) {
                        this.processContactAddedUser(subSplit[3].substring(2));
                    }
                }
                ++i;
            }
        }
        if (input.indexOf("REM") != -1) {
            split = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < split.length) {
                if (split[i].startsWith("REM")) {
                    subSplit = StringUtils.splitOnSpace(split[i]);
                    if (subSplit[2].equals("FL")) {
                        this.processContactRemoved(subSplit[3]);
                    } else if (subSplit[2].equals("RL")) {
                        this.processContactRemovedUser(subSplit[3]);
                    }
                }
                ++i;
            }
        }
        if (input.indexOf("OUT OTH") != -1) {
            split = StringUtils.split(input, "\r\n");
            i = 0;
            while (i < split.length) {
                if (split[i].startsWith("OUT OTH")) {
                    this.close();
                    break;
                }
                ++i;
            }
        }
        return input;
    }

    void close() {
        this.request.setCancelled(true);
        if (this.pingingThread != null) {
            this.pingingThread.interrupt();
        }
        super.close();
    }

    private void ping() {
        this.pingingThread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        1.sleep(60000L);
                        NotificationSession.this.write("PNG");
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.pingingThread.start();
    }

    private void processContactAdded(String email, String contactName, String guid) {
        this.list.addContact(email, contactName, guid);
    }

    private void processContactRemoved(String guid) {
        this.list.fireContactRemoved(guid);
    }

    private void processContactAddedUser(String email) {
        this.list.fireContactAddedUser(email);
    }

    private void processContactRemovedUser(String email) {
        this.list.fireContactRemovedUser(email);
    }

    private void processContactData(String[] eventString, int index) {
        if (eventString.length == index + 1 || StringUtils.splitSubstring(eventString[index], " ", 2).equals("0")) {
            Contact contact = this.list.getContact((eventString = StringUtils.splitOnSpace(eventString[index]))[1]);
            if (contact != null) {
                contact.setPersonalMessage("");
            }
            return;
        }
        String data = eventString[index + 1];
        eventString = StringUtils.splitOnSpace(eventString[index]);
        Contact contact = this.list.getContact(eventString[1]);
        contact.setPersonalMessage(data.substring(data.indexOf("<PSM>") + 5, data.indexOf("</PSM>")));
    }

    private void changeContactInfo(String[] eventString) {
        if (!eventString[1].equals(this.client.getUserEmail())) {
            Contact contact = this.list.getContact(eventString[1]);
            contact.setStatus(Status.getStatus(eventString[0]));
            contact.setDisplayName(eventString[2]);
        }
    }

    private void setContactToOffline(String eventString) {
        String email = StringUtils.splitSubstring(eventString, " ", 1);
        this.list.getContact(email).setStatus(Status.OFFLINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSwitchboardConnectedEvent(ChatSession session) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((ISessionListener)this.listeners.get(i)).sessionConnected(session);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(ISessionListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(ISessionListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(listener);
            }
        }
    }
}

