/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.provider.dnssd.BnRDnsSdServiceTypeID;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryException;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceTypeID;
import org.eclipse.ecf.provider.dnssd.Messages;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;

public abstract class DnsSdDiscoveryContainerAdapter
extends AbstractDiscoveryContainerAdapter {
    protected Resolver resolver;
    protected DnsSdServiceTypeID targetID;

    public DnsSdDiscoveryContainerAdapter(String aNamespaceName, DiscoveryContainerConfig aConfig) {
        super(aNamespaceName, aConfig);
    }

    public IServiceInfo getServiceInfo(IServiceID aServiceId) {
        Assert.isNotNull((Object)aServiceId);
        throw new UnsupportedOperationException(Messages.DnsSdDiscoveryContainerAdapter_No_IDiscovery_Locator);
    }

    public IServiceTypeID[] getServiceTypes() {
        throw new UnsupportedOperationException(Messages.DnsSdDiscoveryContainerAdapter_No_IDiscovery_Locator);
    }

    public IServiceInfo[] getServices() {
        throw new UnsupportedOperationException(Messages.DnsSdDiscoveryContainerAdapter_No_IDiscovery_Locator);
    }

    public IServiceInfo[] getServices(IServiceTypeID aServiceTypeId) {
        Assert.isNotNull((Object)aServiceTypeId);
        throw new UnsupportedOperationException(Messages.DnsSdDiscoveryContainerAdapter_No_IDiscovery_Locator);
    }

    public void registerService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        throw new UnsupportedOperationException(Messages.DnsSdDiscoveryContainerAdapter_No_IDiscovery_Advertiser);
    }

    public void unregisterService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        throw new UnsupportedOperationException(Messages.DnsSdDiscoveryContainerAdapter_No_IDiscovery_Advertiser);
    }

    public abstract void connect(ID var1, IConnectContext var2) throws ContainerConnectException;

    public ID getConnectedID() {
        return this.targetID;
    }

    public void disconnect() {
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), this.getConnectedID()));
        this.targetID = null;
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), this.getConnectedID()));
    }

    protected Collection getBrowsingOrRegistrationDomains(IServiceTypeID aServiceTypeId, String[] rrs) {
        HashSet res = new HashSet();
        this.getBrowsingOrRegistrationDomains(aServiceTypeId, rrs, res);
        return res;
    }

    private void getBrowsingOrRegistrationDomains(IServiceTypeID aServiceTypeId, String[] rrs, Set res) {
        int i = 0;
        while (i < rrs.length) {
            BnRDnsSdServiceTypeID serviceType = new BnRDnsSdServiceTypeID(aServiceTypeId, rrs[i]);
            Record[] records = this.getRecords(serviceType);
            if (records.length == 0) {
                res.addAll(serviceType.getScopesAsZones());
            } else {
                int j = 0;
                while (j < records.length) {
                    PTRRecord record = (PTRRecord)records[j];
                    String target = record.getTarget().toString();
                    if (this.isFinal(record)) {
                        res.add(target.toString());
                    } else if (!res.contains(target)) {
                        BnRDnsSdServiceTypeID newServiceType = new BnRDnsSdServiceTypeID(serviceType, rrs[i]);
                        newServiceType.setScope(target);
                        this.getBrowsingOrRegistrationDomains(newServiceType, rrs, res);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean isFinal(PTRRecord record) {
        Name name = record.getName();
        Name target = record.getTarget();
        return name.subdomain(target);
    }

    protected Record[] getRecords(DnsSdServiceTypeID serviceTypeId) {
        ArrayList<Record> result = new ArrayList<Record>();
        Lookup[] queries = serviceTypeId.getInternalQueries();
        int i = 0;
        while (i < queries.length) {
            Lookup query = queries[i];
            query.setResolver(this.resolver);
            Record[] queryResult = query.run();
            if (queryResult != null) {
                result.addAll(Arrays.asList(queryResult));
            }
            ++i;
        }
        return result.toArray(new Record[result.size()]);
    }

    protected SortedSet getSRVRecords(Lookup[] queries) {
        return this.getSRVRecords(queries, null);
    }

    protected SortedSet getSRVRecords(Lookup[] queries, Comparator aComparator) {
        TreeSet srvRecords = new TreeSet(aComparator);
        int i = 0;
        while (i < queries.length) {
            srvRecords.addAll(this.getSRVRecord(queries[i], aComparator));
            ++i;
        }
        return srvRecords;
    }

    protected SortedSet getSRVRecord(Lookup query, Comparator aComparator) {
        TreeSet<Record> srvRecords = new TreeSet<Record>(aComparator);
        query.setResolver(this.resolver);
        Record[] queryResult = query.run();
        int length = queryResult == null ? 0 : queryResult.length;
        int j = 0;
        while (j < length) {
            Record[] srvQueryResult = null;
            Record record = queryResult[j];
            if (record instanceof PTRRecord) {
                PTRRecord ptrRecord = (PTRRecord)record;
                Name target = ptrRecord.getTarget();
                Lookup srvQuery = new Lookup(target, 33);
                srvQuery.setResolver(this.resolver);
                srvQueryResult = srvQuery.run();
            } else {
                srvQueryResult = record instanceof SRVRecord ? new SRVRecord[]{(SRVRecord)record} : new SRVRecord[]{};
            }
            srvRecords.addAll(Arrays.asList(srvQueryResult));
            ++j;
        }
        return srvRecords;
    }

    public void setSearchPath(String[] searchPaths) {
        this.targetID.setSearchPath(searchPaths);
    }

    public String[] getSearchPath() {
        return this.targetID.getSearchPath();
    }

    public void setResolver(String aResolver) {
        try {
            this.resolver = new SimpleResolver(aResolver);
        }
        catch (UnknownHostException e) {
            throw new DnsSdDiscoveryException(e);
        }
    }

    public void setTsigKey(String tsigKeyName, String tsigKey) {
        this.resolver.setTSIGKey(new TSIG(tsigKeyName, tsigKey));
    }

    protected class SRVRecordComparator
    implements Comparator {
        protected SRVRecordComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof SRVRecord && arg1 instanceof SRVRecord) {
                SRVRecord srv1 = (SRVRecord)arg0;
                SRVRecord srv2 = (SRVRecord)arg1;
                if (srv1.getPriority() > srv2.getPriority()) {
                    return 1;
                }
                if (srv1.getPriority() == srv2.getPriority()) {
                    if (srv1.getWeight() > srv2.getWeight()) {
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }
            throw new UnsupportedOperationException(Messages.DnsSdDiscoveryContainerAdapter_Comparator_SRV_Records);
        }
    }
}

