/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.zookeeper.core.DefaultDiscoveryConfig;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
extends DefaultDiscoveryConfig {
    private File zooConfFile;
    private File zookeeperDataFile;
    private ServiceReference reference;
    private List<String> serverIps = new ArrayList<String>();
    private ZooDiscoveryContainer.FLAVOR flavor;
    private static final String LOCALHOST = "localhost";

    public Configuration(ServiceReference reference) {
        Assert.isNotNull((Object)reference);
        Set<String> legalKeys = this.getConfigProperties().keySet();
        String[] stringArray = reference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (legalKeys.contains(key) || key.startsWith("zoodiscovery.")) {
                this.getConfigProperties().put(key, reference.getProperty(key));
            }
            ++n2;
        }
    }

    public Configuration(ID targetId) {
        this(targetId.getName());
    }

    public Configuration(String propsAsString) {
        String[] ss;
        Assert.isNotNull((Object)propsAsString);
        String[] stringArray = ss = propsAsString.split(";");
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] key_value = s.split("=");
            if (key_value.length == 2) {
                defaultConfigProperties.put(key_value[0], key_value[1]);
            }
            ++n2;
        }
    }

    public Configuration configure() {
        PrintWriter writer = null;
        boolean isNewZookeeperData = false;
        try {
            try {
                String dataDirName = (String)this.getConfigProperties().get("dataDir");
                if ("zookeeperData".equals(dataDirName)) {
                    dataDirName = this.randomDirName();
                }
                this.zookeeperDataFile = new File(new File(this.getConfigProperties().get("tempDir").toString()), dataDirName);
                isNewZookeeperData = this.zookeeperDataFile.mkdir();
                this.zookeeperDataFile.deleteOnExit();
                if (!isNewZookeeperData) {
                    this.clean();
                }
                this.zooConfFile = new File(this.zookeeperDataFile, "zoo.cfg");
                this.zooConfFile.createNewFile();
                this.zooConfFile.deleteOnExit();
                if (this.getConfigProperties().containsKey("zoodiscovery.flavor.centralized")) {
                    this.setFlavor(ZooDiscoveryContainer.FLAVOR.CENTRALIZED);
                    this.serverIps = this.parseIps();
                    if (this.serverIps.size() != 1) {
                        String msg = "ZooDiscovery property zoodiscovery.flavor.centralized must contain exactly one IP address designating the location of the ZooDiscovery instance playing this central role.";
                        Logger.log(1, msg, null);
                        throw new ServiceException(msg);
                    }
                } else if (this.getConfigProperties().containsKey("zoodiscovery.flavor.replicated")) {
                    this.setFlavor(ZooDiscoveryContainer.FLAVOR.REPLICATED);
                    this.serverIps = this.parseIps();
                    if (!this.serverIps.contains(Geo.getHost())) {
                        this.serverIps.add(Geo.getHost());
                    }
                    if (this.serverIps.size() < 2) {
                        String msg = "Industrial Discovery property zoodiscovery.flavor.replicated must contain at least one IP address which is not localhost.";
                        Logger.log(1, msg, null);
                        throw new ServiceException(msg);
                    }
                } else if (this.getConfigProperties().containsKey("zoodiscovery.flavor.standalone")) {
                    this.setFlavor(ZooDiscoveryContainer.FLAVOR.STANDALONE);
                    this.serverIps = this.parseIps();
                }
                Collections.sort(this.serverIps);
                if (this.isQuorum()) {
                    String myip = Geo.getHost();
                    int myId = this.serverIps.indexOf(myip);
                    File myIdFile = new File(this.getZookeeperDataFile(), "myid");
                    myIdFile.createNewFile();
                    myIdFile.deleteOnExit();
                    writer = new PrintWriter(myIdFile);
                    writer.print(myId);
                    writer.flush();
                    writer.close();
                }
                writer = new PrintWriter(this.zooConfFile);
                if (this.isQuorum()) {
                    int i = 0;
                    while (i < this.serverIps.size()) {
                        writer.println("server." + i + "=" + this.serverIps.get(i) + ":" + this.getServerPort() + ":" + this.getElectionPort());
                        ++i;
                    }
                }
                for (String k : this.getConfigProperties().keySet()) {
                    if (k.startsWith("zoodiscovery.")) continue;
                    writer.println(String.valueOf(k) + "=" + this.getConfigProperties().get(k));
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                Logger.log(1, e.getMessage(), e);
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return this;
    }

    private String randomDirName() {
        String name = "" + UUID.randomUUID();
        name = name.replaceAll("-", "");
        return "zdd" + name;
    }

    public int getElectionPort() {
        return (Integer)this.getConfigProperties().get("electionPort");
    }

    public String getConfFile() {
        return this.zooConfFile.toString();
    }

    public String getServerIps() {
        String ipsString = "";
        for (String i : this.serverIps) {
            ipsString = String.valueOf(ipsString) + i + ",";
        }
        return ipsString.substring(0, ipsString.lastIndexOf(","));
    }

    public int getClientPort() {
        return Integer.parseInt((String)this.getConfigProperties().get("clientPort"));
    }

    public List<String> getServerIpsAsList() {
        return this.serverIps;
    }

    public File getZookeeperDataFile() {
        return this.zookeeperDataFile;
    }

    public void setFlavor(ZooDiscoveryContainer.FLAVOR flavor) {
        this.flavor = flavor;
    }

    public ZooDiscoveryContainer.FLAVOR getFlavor() {
        return this.flavor;
    }

    public boolean isQuorum() {
        return this.flavor == ZooDiscoveryContainer.FLAVOR.REPLICATED;
    }

    public boolean isCentralized() {
        return this.flavor == ZooDiscoveryContainer.FLAVOR.CENTRALIZED;
    }

    public boolean isStandAlone() {
        return this.flavor == ZooDiscoveryContainer.FLAVOR.STANDALONE;
    }

    public ServiceReference getReference() {
        return this.reference;
    }

    private void clean() {
        File[] fileArray = this.zookeeperDataFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                if (file.isDirectory()) {
                    File[] fileArray2 = file.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray2[n4];
                        f.delete();
                        ++n4;
                    }
                }
                file.delete();
            }
            catch (Throwable t) {
                Logger.log(1, t.getMessage(), null);
            }
            ++n2;
        }
    }

    private List<String> parseIps() {
        List<String> ips = Arrays.asList(((String)this.getConfigProperties().get(this.flavor.toString())).split(","));
        ArrayList<String> unfixedSize = new ArrayList<String>();
        for (String ip : ips) {
            if (ip.contains(LOCALHOST)) {
                ip = ip.replace(LOCALHOST, Geo.getHost());
            }
            unfixedSize.add(ip);
        }
        Collections.sort(unfixedSize);
        return unfixedSize;
    }

    public String toString() {
        String s = this.flavor.name();
        for (String o : this.parseIps()) {
            s = String.valueOf(s) + o;
        }
        return s;
    }

    public int getTickTime() {
        return Integer.parseInt((String)this.getConfigProperties().get("tickTime"));
    }

    public int getServerPort() {
        return Integer.parseInt((String)this.getConfigProperties().get("serverPort"));
    }
}

