/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.net.ConnectException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.ContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.IConnectInitiatorPolicy;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerClient;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.sharedobject.SharedObjectDescription;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.ConnectionCreateException;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.gmm.Member;

public abstract class ClientSOContainer
extends SOContainer
implements ISharedObjectContainerClient {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    protected ISynchAsynchConnection connection = null;
    protected ID remoteServerID;
    protected byte connectionState = 0;
    protected IConnectInitiatorPolicy connectPolicy = null;
    public static final byte DISCONNECTED = 0;
    public static final byte CONNECTING = 1;
    public static final byte CONNECTED = 2;
    protected Lock connectLock = new Lock();

    public ClientSOContainer(ISharedObjectContainerConfig config) {
        super(config);
    }

    protected Lock getConnectLock() {
        return this.connectLock;
    }

    protected ISynchAsynchConnection getConnection() {
        return this.connection;
    }

    public void setConnectInitiatorPolicy(IConnectInitiatorPolicy policy) {
        this.connectPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.isClosing = true;
            if (this.isConnected()) {
                this.disconnect();
            } else {
                this.setStateDisconnected(this.connection);
            }
        }
        super.dispose();
    }

    public final boolean isGroupManager() {
        return false;
    }

    public ID getConnectedID() {
        return this.remoteServerID;
    }

    private void setStateDisconnected(ISynchAsynchConnection conn) {
        this.disconnect(conn);
        this.connectionState = 0;
        this.connection = null;
        this.remoteServerID = null;
    }

    private void setStateConnecting(ISynchAsynchConnection conn) {
        this.connectionState = 1;
        this.connection = conn;
    }

    private void setStateConnected(ID serverID, ISynchAsynchConnection conn) {
        this.connectionState = (byte)2;
        this.connection = conn;
        this.remoteServerID = serverID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID targetID, IConnectContext joinContext) throws ContainerConnectException {
        try {
            if (this.isClosing) {
                throw new IllegalStateException("Container closing");
            }
            if (targetID == null) {
                throw new ContainerConnectException("targetID cannot be null");
            }
            Object response = null;
            Lock lock = this.getConnectLock();
            synchronized (lock) {
                if (this.isConnected()) {
                    throw new IllegalStateException("Container already connected connectedID=" + this.getConnectedID());
                }
                if (this.isConnecting()) {
                    throw new IllegalStateException("Container connecting");
                }
                ISynchAsynchConnection aConnection = this.createConnection(targetID, joinContext);
                this.setStateConnecting(aConnection);
                this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), targetID, (Object)joinContext));
                Object connectData = this.getConnectData(targetID, joinContext);
                int connectTimeout = this.getConnectTimeout();
                ISynchAsynchConnection iSynchAsynchConnection = aConnection;
                synchronized (iSynchAsynchConnection) {
                    try {
                        response = aConnection.connect(targetID, connectData, connectTimeout);
                    }
                    catch (ECFException e) {
                        if (this.getConnection() != aConnection) {
                            this.disconnect(aConnection);
                        } else {
                            this.setStateDisconnected(aConnection);
                        }
                        throw e;
                    }
                    if (this.getConnection() != aConnection) {
                        this.disconnect(aConnection);
                        throw new IllegalStateException("Container connect failed because not in correct state");
                    }
                    ID serverID = null;
                    try {
                        serverID = this.handleConnectResponse(targetID, response);
                    }
                    catch (Exception e) {
                        this.setStateDisconnected(aConnection);
                        throw e;
                    }
                    this.setStateConnected(serverID, aConnection);
                    this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), this.remoteServerID));
                    aConnection.start();
                }
            }
        }
        catch (ContainerConnectException e) {
            throw e;
        }
        catch (ECFException e) {
            IStatus s = e.getStatus();
            throw new ContainerConnectException(s.getMessage(), s.getException());
        }
        catch (Exception e) {
            throw new ContainerConnectException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected Callback[] createAuthorizationCallbacks() {
        return null;
    }

    protected Object getConnectData(ID remote, IConnectContext joinContext) throws IOException, UnsupportedCallbackException {
        Object connectData = null;
        if (this.connectPolicy != null) {
            connectData = this.connectPolicy.createConnectData((IContainer)this, remote, joinContext);
        } else {
            CallbackHandler handler;
            Callback[] callbacks = this.createAuthorizationCallbacks();
            if (joinContext != null && (handler = joinContext.getCallbackHandler()) != null) {
                handler.handle(callbacks);
            }
        }
        return ContainerMessage.createJoinGroupMessage(this.getID(), remote, this.getNextSequenceNumber(), (Serializable)connectData);
    }

    protected int getConnectTimeout() {
        if (this.connectPolicy != null) {
            return this.connectPolicy.getConnectTimeout();
        }
        return 30000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLeaveGroupMessage(ContainerMessage mess) {
        if (!this.isConnected()) {
            return;
        }
        ContainerMessage.LeaveGroupMessage lgm = (ContainerMessage.LeaveGroupMessage)mess.getData();
        ID fromID = mess.getFromContainerID();
        if (fromID == null || !fromID.equals((Object)this.remoteServerID)) {
            return;
        }
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            this.handleLeave(fromID, this.connection);
        }
        this.fireContainerEvent((IContainerEvent)new ContainerEjectedEvent(this.getID(), fromID, lgm.getData()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChangeMessage(ContainerMessage mess) throws IOException {
        if (!this.isConnected()) {
            return;
        }
        ContainerMessage.ViewChangeMessage vc = (ContainerMessage.ViewChangeMessage)mess.getData();
        if (vc == null) {
            throw new IOException("view change message cannot be null");
        }
        ID fromID = mess.getFromContainerID();
        if (fromID == null || !fromID.equals((Object)this.remoteServerID)) {
            throw new IOException("view change message fromID=" + fromID + " is not from remoteServerID=" + this.remoteServerID);
        }
        ID[] changeIDs = vc.getChangeIDs();
        if (changeIDs != null) {
            int i = 0;
            while (i < changeIDs.length) {
                Object object;
                if (vc.isAdd()) {
                    boolean wasAdded = false;
                    object = this.getGroupMembershipLock();
                    synchronized (object) {
                        if (this.groupManager.getMemberForID(changeIDs[i]) == null) {
                            wasAdded = true;
                            this.groupManager.addMember(new Member(changeIDs[i]));
                        }
                    }
                    if (wasAdded) {
                        this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), changeIDs[i]));
                    }
                } else if (changeIDs[i].equals((Object)this.getID())) {
                    ID serverID = this.remoteServerID;
                    object = this.getGroupMembershipLock();
                    synchronized (object) {
                        this.handleLeave(this.remoteServerID, this.connection);
                    }
                    this.fireContainerEvent((IContainerEvent)new ContainerEjectedEvent(this.getID(), serverID, vc.getData()));
                } else {
                    Object object2 = this.getGroupMembershipLock();
                    synchronized (object2) {
                        this.groupManager.removeMember(changeIDs[i]);
                    }
                    this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), changeIDs[i]));
                }
                ++i;
            }
        }
    }

    protected void forwardExcluding(ID from, ID excluding, ContainerMessage data) throws IOException {
    }

    protected Serializable getLeaveData(ID target) {
        return null;
    }

    public void disconnect() {
        this.disconnect((Throwable)null);
    }

    protected abstract ISynchAsynchConnection createConnection(ID var1, Object var2) throws ConnectionCreateException;

    protected void queueContainerMessage(ContainerMessage message) throws IOException {
        this.connection.sendAsynch(message.getToContainerID(), ClientSOContainer.serialize(message));
    }

    protected void forwardExcluding(ID from, ID excluding, byte msg, Serializable data) throws IOException {
    }

    protected void forwardToRemote(ID from, ID to, ContainerMessage message) throws IOException {
    }

    protected ID getIDForConnection(IAsynchConnection conn) {
        return this.remoteServerID;
    }

    protected void handleLeave(ID fromID, IConnection conn) {
        if (fromID.equals((Object)this.remoteServerID)) {
            this.groupManager.removeNonLocalMembers();
            super.handleLeave(fromID, conn);
            this.setStateDisconnected(null);
        } else if (fromID.equals((Object)this.getID())) {
            super.handleLeave(fromID, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(ContainerMessage data) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendMessage(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ID[] sendCreateMsg(ID toID, SharedObjectDescription createInfo) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            return super.sendCreateSharedObjectMessage(toID, createInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCreate(ID sharedObjectId, ID toContainerId, SharedObjectDescription sd) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendCreate(sharedObjectId, toContainerId, sd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCreateResponse(ID homeId, ID sharedObjectId, Throwable t, long identifier) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendCreateResponse(homeId, sharedObjectId, t, identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCreateResponseSharedObjectMessage(ID toContainerId, ID fromSharedObject, Throwable t, long ident) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendCreateResponseSharedObjectMessage(toContainerId, fromSharedObject, t, ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ID[] sendCreateSharedObjectMessage(ID toContainerId, SharedObjectDescription sd) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            return super.sendCreateSharedObjectMessage(toContainerId, sd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDispose(ID toContainerId, ID sharedObjectId) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendDispose(toContainerId, sharedObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDisposeSharedObjectMessage(ID toContainerId, ID fromSharedObject) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendDisposeSharedObjectMessage(toContainerId, fromSharedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(ID toContainerId, ID sharedObjectId, Object message) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendMessage(toContainerId, sharedObjectId, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSharedObjectMessage(ID toContainerId, ID fromSharedObject, Serializable data) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.sendSharedObjectMessage(toContainerId, fromSharedObject, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(Throwable exception) {
        Lock lock = this.getConnectLock();
        synchronized (lock) {
            if (this.isConnected()) {
                ID groupID = this.getConnectedID();
                if (exception == null) {
                    this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), groupID));
                }
                ISynchAsynchConnection iSynchAsynchConnection = this.connection;
                synchronized (iSynchAsynchConnection) {
                    try {
                        this.connection.sendSynch(groupID, ClientSOContainer.serialize(ContainerMessage.createLeaveGroupMessage(this.getID(), groupID, this.getNextSequenceNumber(), this.getLeaveData(groupID))));
                    }
                    catch (Exception e) {
                        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4, "disconnect.sendSynch", (Throwable)e));
                    }
                    Object object = this.getGroupMembershipLock();
                    synchronized (object) {
                        this.handleLeave(groupID, this.connection);
                    }
                }
                if (exception == null) {
                    this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), groupID));
                } else {
                    this.fireContainerEvent((IContainerEvent)new ContainerEjectedEvent(this.getID(), groupID, (Serializable)exception));
                }
            }
        }
    }

    protected void processDisconnect(DisconnectEvent evt) {
        this.disconnect(evt.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAsynch(AsynchEvent evt) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            super.processAsynch(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable processSynch(SynchEvent evt) throws IOException {
        Lock lock = this.connectLock;
        synchronized (lock) {
            this.checkConnected();
            IConnection conn = evt.getConnection();
            if (this.connection != conn) {
                throw new ConnectException("Container not connected");
            }
            return super.processSynch(evt);
        }
    }

    protected boolean isConnected() {
        return this.connectionState == 2;
    }

    protected boolean isConnecting() {
        return this.connectionState == 1;
    }

    private void checkConnected() throws ConnectException {
        if (!this.isConnected()) {
            throw new ConnectException("Container not connected");
        }
    }

    protected ID handleConnectResponse(ID orginalTarget, Object serverData) throws Exception {
        ContainerMessage aPacket = (ContainerMessage)serverData;
        ID fromID = aPacket.getFromContainerID();
        Assert.isNotNull((Object)fromID, (String)"fromID cannot be null");
        ContainerMessage.ViewChangeMessage viewChangeMessage = (ContainerMessage.ViewChangeMessage)aPacket.getData();
        if (!viewChangeMessage.isAdd()) {
            Serializable data = viewChangeMessage.getData();
            if (data != null && data instanceof Exception) {
                throw (Exception)data;
            }
            throw new InvalidObjectException("Invalid server response");
        }
        ID[] ids = viewChangeMessage.getChangeIDs();
        Assert.isNotNull((Object)ids, (String)"view change ids cannot be null");
        int i = 0;
        while (i < ids.length) {
            ID id = ids[i];
            if (id != null && !id.equals((Object)this.getID())) {
                this.addNewRemoteMember(id, null);
            }
            ++i;
        }
        return fromID;
    }

    static final class Lock {
        Lock() {
        }
    }
}

