/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.AbstractContainer;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.jobs.JobsExecutor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.remoteservice.Activator;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameterSerializer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteResponseDeserializer;
import org.eclipse.ecf.remoteservice.client.IRemoteServiceClientContainerAdapter;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientReference;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistry;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.ecf.remoteservice.util.RemoteFilterImpl;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.osgi.framework.InvalidSyntaxException;

public abstract class AbstractClientContainer
extends AbstractContainer
implements IRemoteServiceClientContainerAdapter {
    protected ID containerID;
    protected ID connectedID;
    protected Object connectLock = new Object();
    protected IConnectContext connectContext;
    protected Object remoteResponseDeserializerLock = new Object();
    protected IRemoteResponseDeserializer remoteResponseDeserializer = null;
    protected Object parameterSerializerLock = new Object();
    protected IRemoteCallParameterSerializer parameterSerializer = null;
    protected RemoteServiceClientRegistry registry;
    protected List remoteServiceListeners = new ArrayList();
    private List referencesInUse = new ArrayList();
    protected boolean alwaysSendDefaultParameters;

    public AbstractClientContainer(ID containerID) {
        this.containerID = containerID;
        Assert.isNotNull((Object)this.containerID);
        this.registry = new RemoteServiceClientRegistry(this);
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public IConnectContext getConnectContextForAuthentication() {
        return this.connectContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseDeserializer(IRemoteResponseDeserializer resource) {
        Object object = this.remoteResponseDeserializerLock;
        synchronized (object) {
            this.remoteResponseDeserializer = resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteResponseDeserializer getResponseDeserializer() {
        Object object = this.remoteResponseDeserializerLock;
        synchronized (object) {
            return this.remoteResponseDeserializer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterSerializer(IRemoteCallParameterSerializer serializer) {
        Object object = this.parameterSerializerLock;
        synchronized (object) {
            this.parameterSerializer = serializer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRemoteCallParameterSerializer getParameterSerializer() {
        Object object = this.parameterSerializerLock;
        synchronized (object) {
            return this.parameterSerializer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRemoteResponseDeserializer getResponseDeserializer(IRemoteCall call, IRemoteCallable callable, Map responseHeaders) {
        Object object = this.remoteResponseDeserializerLock;
        synchronized (object) {
            return this.remoteResponseDeserializer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRemoteCallParameterSerializer getParameterSerializer(IRemoteCallParameter parameter, Object value) {
        Object object = this.parameterSerializerLock;
        synchronized (object) {
            return this.parameterSerializer;
        }
    }

    public void setAlwaysSendDefaultParameters(boolean alwaysSendDefaultParameters) {
        this.alwaysSendDefaultParameters = alwaysSendDefaultParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteServiceListener(IRemoteServiceListener listener) {
        List list = this.remoteServiceListeners;
        synchronized (list) {
            this.remoteServiceListeners.add(listener);
        }
    }

    public IFuture asyncGetRemoteServiceReferences(final ID[] idFilter, final String clazz, final String filter) {
        JobsExecutor executor = new JobsExecutor("asyncGetRemoteServiceReferences");
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractClientContainer.this.getRemoteServiceReferences(idFilter, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final String clazz, final String filter) {
        JobsExecutor executor = new JobsExecutor("asyncGetRemoteServiceReferences");
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractClientContainer.this.getRemoteServiceReferences(target, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final ID[] idFilter, final String clazz, final String filter) {
        JobsExecutor executor = new JobsExecutor("asyncGetRemoteServiceReferences");
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractClientContainer.this.getRemoteServiceReferences(target, idFilter, clazz, filter);
            }
        }, null);
    }

    public IRemoteFilter createRemoteFilter(String filter) throws InvalidSyntaxException {
        return new RemoteFilterImpl(filter);
    }

    public IRemoteServiceReference[] getAllRemoteServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.registry.getAllRemoteServiceReferences(clazz, filter == null ? null : this.createRemoteFilter(filter));
    }

    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        IRemoteService result;
        if (reference == null || !(reference instanceof RemoteServiceClientReference)) {
            return null;
        }
        RemoteServiceClientRegistration registration = this.registry.findServiceRegistration((RemoteServiceClientReference)reference);
        if (registration == null) {
            return null;
        }
        IRemoteService iRemoteService = result = registration == null ? null : this.createRemoteService(registration);
        if (result != null) {
            this.referencesInUse.add(reference);
        }
        return result;
    }

    public IRemoteServiceID getRemoteServiceID(ID containerID1, long containerRelativeID) {
        return this.registry.getRemoteServiceID(containerID1, containerRelativeID);
    }

    public Namespace getRemoteServiceNamespace() {
        return this.getConnectNamespace();
    }

    public IRemoteServiceReference getRemoteServiceReference(IRemoteServiceID serviceID) {
        return this.registry.findServiceReference(serviceID);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        return this.registry.getRemoteServiceReferences(idFilter, clazz, filter == null ? null : this.createRemoteFilter(filter));
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return this.registry.getRemoteServiceReferences(target, clazz, filter == null ? null : this.createRemoteFilter(filter));
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return this.registry.getRemoteServiceReferences(target, idFilter, clazz, filter == null ? null : this.createRemoteFilter(filter));
    }

    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        throw new RuntimeException("registerRemoteService cannot be used with client container");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteServiceListener(IRemoteServiceListener listener) {
        List list = this.remoteServiceListeners;
        synchronized (list) {
            this.remoteServiceListeners.remove(listener);
        }
    }

    public boolean ungetRemoteService(final IRemoteServiceReference reference) {
        boolean result = this.referencesInUse.contains(reference);
        this.referencesInUse.remove(reference);
        this.fireRemoteServiceEvent(new IRemoteServiceUnregisteredEvent(){

            public IRemoteServiceReference getReference() {
                return reference;
            }

            public ID getLocalContainerID() {
                return AbstractClientContainer.this.getID();
            }

            public ID getContainerID() {
                return AbstractClientContainer.this.getID();
            }

            public String[] getClazzes() {
                return AbstractClientContainer.this.registry.getClazzes(reference);
            }
        });
        return result;
    }

    public IRemoteServiceRegistration registerCallables(IRemoteCallable[] callables, Dictionary properties) {
        Assert.isNotNull((Object)callables);
        final RemoteServiceClientRegistration registration = this.createRestServiceRegistration(callables, properties);
        this.registry.registerRegistration(registration);
        this.fireRemoteServiceEvent(new IRemoteServiceRegisteredEvent(){

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public ID getLocalContainerID() {
                return registration.getContainerID();
            }

            public ID getContainerID() {
                return AbstractClientContainer.this.getID();
            }

            public String[] getClazzes() {
                return registration.getClazzes();
            }
        });
        return registration;
    }

    public IRemoteServiceRegistration registerCallables(String[] clazzes, IRemoteCallable[][] callables, Dictionary properties) {
        final RemoteServiceClientRegistration registration = this.createRestServiceRegistration(clazzes, callables, properties);
        this.registry.registerRegistration(registration);
        this.fireRemoteServiceEvent(new IRemoteServiceRegisteredEvent(){

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public ID getLocalContainerID() {
                return registration.getContainerID();
            }

            public ID getContainerID() {
                return AbstractClientContainer.this.getID();
            }

            public String[] getClazzes() {
                return registration.getClazzes();
            }
        });
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID targetID, IConnectContext connectContext1) throws ContainerConnectException {
        if (targetID == null) {
            throw new ContainerConnectException("targetID cannot be null");
        }
        Namespace targetNamespace = targetID.getNamespace();
        Namespace connectNamespace = this.getConnectNamespace();
        if (connectNamespace == null) {
            throw new ContainerConnectException("targetID namespace cannot be null");
        }
        if (!targetNamespace.getName().equals(connectNamespace.getName())) {
            throw new ContainerConnectException("targetID of incorrect type");
        }
        this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.containerID, targetID));
        Object object = this.connectLock;
        synchronized (object) {
            if (this.connectedID == null) {
                this.connectedID = targetID;
                this.connectContext = connectContext1;
            } else if (!this.connectedID.equals((Object)targetID)) {
                throw new ContainerConnectException("Already connected to " + this.connectedID.getName());
            }
        }
        this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.containerID, targetID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ID oldId = this.connectedID;
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.containerID, oldId));
        Object object = this.connectLock;
        synchronized (object) {
            this.connectedID = null;
            this.connectContext = null;
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.containerID, oldId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID getConnectedID() {
        Object object = this.connectLock;
        synchronized (object) {
            return this.connectedID;
        }
    }

    public ID getID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disconnect();
        List list = this.remoteServiceListeners;
        synchronized (list) {
            this.remoteServiceListeners.clear();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRemoteServiceEvent(IRemoteServiceEvent event) {
        ArrayList toNotify = null;
        List list = this.remoteServiceListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.remoteServiceListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            ((IRemoteServiceListener)i.next()).handleServiceEvent(event);
        }
    }

    protected RemoteServiceClientRegistration createRestServiceRegistration(String[] clazzes, IRemoteCallable[][] callables, Dictionary properties) {
        return new RemoteServiceClientRegistration(this.getRemoteServiceNamespace(), clazzes, callables, properties, this.registry);
    }

    protected RemoteServiceClientRegistration createRestServiceRegistration(IRemoteCallable[] callables, Dictionary properties) {
        return new RemoteServiceClientRegistration(this.getRemoteServiceNamespace(), callables, properties, this.registry);
    }

    protected void logException(String string, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(4, "org.eclipse.ecf.remoteservice", string, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ID getRemoteCallTargetID() {
        Object object = this.connectLock;
        synchronized (object) {
            ID cID = this.getConnectedID();
            return cID == null ? this.getID() : cID;
        }
    }

    protected IRemoteCallParameter[] prepareParameters(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        ArrayList<Object> results = new ArrayList<Object>();
        Object[] callParameters = call.getParameters();
        IRemoteCallParameter[] defaultCallableParameters = callable.getDefaultParameters();
        if (callParameters == null) {
            return defaultCallableParameters;
        }
        int i = 0;
        while (i < callParameters.length) {
            Object p = callParameters[i];
            if (p instanceof IRemoteCallParameter) {
                results.add(p);
            } else if (defaultCallableParameters != null && i < defaultCallableParameters.length) {
                IRemoteCallParameter val;
                if (p == null) {
                    results.add(defaultCallableParameters[i]);
                }
                if ((val = this.serializeParameter(uri, call, callable, defaultCallableParameters[i], p)) != null) {
                    results.add(val);
                }
            }
            ++i;
        }
        if (this.alwaysSendDefaultParameters && defaultCallableParameters.length > callParameters.length) {
            i = callParameters.length;
            while (i < defaultCallableParameters.length) {
                IRemoteCallParameter param = defaultCallableParameters[i];
                if (param.getValue() != null) {
                    IRemoteCallParameter serialziedParam = this.serializeParameter(uri, call, callable, param, param.getValue());
                    results.add(serialziedParam);
                }
                ++i;
            }
        }
        return results.toArray(new IRemoteCallParameter[0]);
    }

    protected IRemoteCallParameter serializeParameter(String uri, IRemoteCall call, IRemoteCallable callable, IRemoteCallParameter defaultParameter, Object parameterValue) throws NotSerializableException {
        IRemoteCallParameterSerializer serializer = this.getParameterSerializer();
        IRemoteCallParameter val = serializer == null ? null : serializer.serializeParameter(uri, call, callable, defaultParameter, parameterValue);
        return val;
    }

    protected Object processResponse(String uri, IRemoteCall call, IRemoteCallable callable, Map responseHeaders, String responseBody) throws NotSerializableException {
        IRemoteResponseDeserializer deserializer = this.getResponseDeserializer();
        return deserializer == null ? null : deserializer.deserializeResponse(uri, call, callable, responseHeaders, responseBody);
    }

    protected abstract IRemoteService createRemoteService(RemoteServiceClientRegistration var1);

    protected abstract String prepareEndpointAddress(IRemoteCall var1, IRemoteCallable var2);
}

