/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.internal.mylyn.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.internal.mylyn.ui.Messages;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class CommitHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String content;
        IDocument document = textViewer.getDocument();
        if (document == null || document.getLength() == 0) {
            return null;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        try {
            if (length == 0) {
                IRegion lineInformation = document.getLineInformationOfOffset(offset);
                offset = lineInformation.getOffset();
                length = lineInformation.getLength();
            }
            content = document.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        ArrayList<CommitHyperlink> hyperlinks = new ArrayList<CommitHyperlink>();
        String[] words = content.split(" ");
        Shell shell = textViewer.getTextWidget().getShell();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String potentialId = stringArray[n2];
            String foundId = null;
            int foundOffset = 0;
            if (ObjectId.isId((String)potentialId)) {
                foundId = potentialId;
                foundOffset = offset;
            } else if (potentialId.length() > 40) {
                String potentialIdAtBeginning = potentialId.substring(0, 40);
                if (ObjectId.isId((String)potentialIdAtBeginning)) {
                    foundId = potentialIdAtBeginning;
                    foundOffset = offset;
                } else {
                    String potentialIdAtEnd = potentialId.substring(potentialId.length() - 40);
                    if (ObjectId.isId((String)potentialIdAtEnd)) {
                        foundId = potentialIdAtEnd;
                        foundOffset = potentialId.length() - 40;
                    }
                }
            }
            if (foundId != null) {
                CommitHyperlink hyperlink = new CommitHyperlink((IRegion)new Region(foundOffset, 40), foundId, shell);
                hyperlinks.add(hyperlink);
            }
            offset += potentialId.length() + 1;
            ++n2;
        }
        if (region.getLength() == 0) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                IHyperlink hyperlink = (IHyperlink)it.next();
                IRegion hyperlinkRegion = hyperlink.getHyperlinkRegion();
                if (this.isInRegion(region, hyperlinkRegion)) continue;
                it.remove();
            }
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    private boolean isInRegion(IRegion detectInRegion, IRegion hyperlinkRegion) {
        return detectInRegion.getOffset() >= hyperlinkRegion.getOffset() && detectInRegion.getOffset() <= hyperlinkRegion.getOffset() + hyperlinkRegion.getLength();
    }

    private static class CommitHyperlink
    implements IHyperlink {
        private IRegion region;
        private String objectId;
        private final Shell shell;

        public CommitHyperlink(IRegion region, String objectId, Shell shell) {
            this.shell = shell;
            Assert.isNotNull((Object)objectId);
            Assert.isNotNull((Object)region);
            Assert.isNotNull((Object)shell);
            this.region = region;
            this.objectId = objectId;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return this.objectId;
        }

        public void open() {
            try {
                RepositoryCommit commit = this.searchCommit();
                if (commit != null) {
                    CommitEditor.openQuiet((RepositoryCommit)commit);
                } else {
                    this.informCommitNotFound();
                }
            }
            catch (IOException iOException) {}
        }

        private void informCommitNotFound() {
            MessageDialog.openWarning((Shell)this.shell, (String)Messages.CommitHyperlinkDetector_CommitNotFound, (String)NLS.bind((String)Messages.CommitHyperlinkDetector_CommitNotFoundInRepositories, (Object)this.objectId));
        }

        private RepositoryCommit searchCommit() throws IOException {
            RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
            List configuredRepositories = repositoryUtil.getConfiguredRepositories();
            RepositoryCache repositoryCache = Activator.getDefault().getRepositoryCache();
            for (String repoDir : configuredRepositories) {
                Repository repository = repositoryCache.lookupRepository(new File(repoDir));
                RevCommit commit = this.getCommit(repository);
                if (commit == null) continue;
                return new RepositoryCommit(repository, commit);
            }
            return null;
        }

        private RevCommit getCommit(Repository repository) throws IOException {
            RevWalk revWalk = null;
            try {
                revWalk = new RevWalk(repository);
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)ObjectId.fromString((String)this.objectId));
                return revCommit;
            }
            catch (MissingObjectException missingObjectException) {
                return null;
            }
            catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                return null;
            }
            finally {
                if (revWalk != null) {
                    revWalk.release();
                }
            }
        }
    }
}

