/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.egit.ui.internal.synchronize.SelectSynchronizeResourceDialog;
import org.eclipse.egit.ui.internal.synchronize.SyncRepoEntity;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeWithActionHandler
extends RepositoryActionHandler {
    private static final Pattern PATTERN = Pattern.compile("^(refs/heads/)|(refs/remotes/)|(refs/tags/)|(refs/)");

    public boolean isEnabled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository[] repos = this.getRepositories(event);
        if (repos.length == 0) {
            return null;
        }
        GitSynchronizeDataSet gsdSet = new GitSynchronizeDataSet();
        Repository[] repositoryArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            SelectSynchronizeResourceDialog dialog;
            Repository repo;
            block6: {
                repo = repositoryArray[n2];
                List<SyncRepoEntity> syncRepoEntities = this.createSyncRepoEntities(repo);
                dialog = new SelectSynchronizeResourceDialog(this.getShell(event), repo.getDirectory(), syncRepoEntities);
                if (dialog.open() == 0) break block6;
                return null;
            }
            try {
                gsdSet.add(new GitSynchronizeData(repo, dialog.getSrcRef(), dialog.getDstRef(), dialog.shouldIncludeLocal()));
            }
            catch (URISyntaxException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            ++n2;
        }
        GitModelSynchronize.launch(gsdSet, this.getSelectedResources(event));
        return null;
    }

    private List<SyncRepoEntity> createSyncRepoEntities(Repository repo) throws URISyntaxException, IOException {
        RefDatabase refDatabase = repo.getRefDatabase();
        List<RemoteConfig> remoteConfigs = this.getRemoteConfigs(repo);
        ArrayList<SyncRepoEntity> syncRepoEntities = new ArrayList<SyncRepoEntity>();
        syncRepoEntities.add(this.getLocalSyncRepo(repo));
        syncRepoEntities.add(this.getTagsSyncRepo(repo));
        for (RemoteConfig rc : remoteConfigs) {
            syncRepoEntities.add(this.getRemoteSyncRepo(refDatabase, rc));
        }
        return syncRepoEntities;
    }

    private List<RemoteConfig> getRemoteConfigs(Repository repo) throws URISyntaxException {
        return RemoteConfig.getAllRemoteConfigs((Config)repo.getConfig());
    }

    private SyncRepoEntity getLocalSyncRepo(Repository repo) {
        Set allRefs = repo.getAllRefs().keySet();
        SyncRepoEntity local = new SyncRepoEntity(UIText.SynchronizeWithAction_localRepoName);
        for (String ref : allRefs) {
            if (ref.startsWith("refs/remotes/") || ref.startsWith("refs/tags/")) continue;
            local.addRef(this.createSyncRepoEntity(ref));
        }
        return local;
    }

    private SyncRepoEntity getRemoteSyncRepo(RefDatabase refDatabase, RemoteConfig rc) throws IOException {
        String name = rc.getName();
        SyncRepoEntity syncRepoEnt = new SyncRepoEntity(name);
        Collection<Ref> remoteRefs = this.getRemoteRef(refDatabase, name);
        for (Ref ref : remoteRefs) {
            syncRepoEnt.addRef(this.createSyncRepoEntity(name, ref.getName()));
        }
        return syncRepoEnt;
    }

    private SyncRepoEntity getTagsSyncRepo(Repository repo) {
        Set allRefs = repo.getAllRefs().keySet();
        SyncRepoEntity local = new SyncRepoEntity(UIText.SynchronizeWithAction_tagsName);
        for (String ref : allRefs) {
            if (!ref.startsWith("refs/tags/")) continue;
            local.addRef(this.createSyncRepoEntity(ref));
        }
        return local;
    }

    private SyncRepoEntity.SyncRefEntity createSyncRepoEntity(String ref) {
        return this.createSyncRepoEntity("", ref);
    }

    private SyncRepoEntity.SyncRefEntity createSyncRepoEntity(String repoName, String ref) {
        String name = PATTERN.matcher(ref).replaceFirst("");
        if (name.startsWith(String.valueOf(repoName) + "/")) {
            name = name.substring(repoName.length() + 1);
        }
        return new SyncRepoEntity.SyncRefEntity(name, ref);
    }

    private Collection<Ref> getRemoteRef(RefDatabase refDb, String remoteName) throws IOException {
        return refDb.getRefs("refs/remotes/" + remoteName + "/").values();
    }
}

