/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CreateTagDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class TagActionHandler
extends RepositoryActionHandler {
    private Repository repo;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevObject tagTarget;
        String currentBranchName;
        this.repo = this.getRepository(true, event);
        if (this.repo == null) {
            return null;
        }
        if (!this.repo.getRepositoryState().canCheckout()) {
            MessageDialog.openError((Shell)this.getShell(event), (String)UIText.TagAction_cannotCheckout, (String)NLS.bind((String)UIText.TagAction_repositoryState, (Object)this.repo.getRepositoryState().getDescription()));
            return null;
        }
        try {
            currentBranchName = this.repo.getBranch();
        }
        catch (IOException e) {
            Activator.handleError(UIText.TagAction_cannotGetBranchName, e, true);
            return null;
        }
        CreateTagDialog dialog = new CreateTagDialog(this.getShell(event), currentBranchName, this.repo);
        if (dialog.open() != 0) {
            return null;
        }
        final TagBuilder tag = new TagBuilder();
        PersonIdent personIdent = new PersonIdent(this.repo);
        String tagName = dialog.getTagName();
        tag.setTag(tagName);
        tag.setTagger(personIdent);
        tag.setMessage(dialog.getTagMessage());
        try {
            tagTarget = this.getTagTarget(dialog.getTagCommit());
        }
        catch (IOException e1) {
            Activator.handleError(UIText.TagAction_unableToResolveHeadObjectId, e1, true);
            return null;
        }
        tag.setObjectId(tagTarget);
        String tagJobName = NLS.bind((String)UIText.TagAction_creating, (Object)tagName);
        final boolean shouldMoveTag = dialog.shouldOverWriteTag();
        Job tagJob = new Job(tagJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        new TagOperation(TagActionHandler.this.repo, tag, shouldMoveTag).execute(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(UIText.TagAction_taggingFailed, e);
                        GitLightweightDecorator.refresh();
                        return iStatus;
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.TAG)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        tagJob.setUser(true);
        tagJob.schedule();
        return null;
    }

    public boolean isEnabled() {
        return this.getRepository() != null && this.containsHead();
    }

    private RevObject getTagTarget(ObjectId objectId) throws IOException {
        RevWalk rw = new RevWalk(this.repo);
        try {
            if (objectId == null) {
                RevObject revObject = rw.parseAny((AnyObjectId)this.repo.resolve("HEAD"));
                return revObject;
            }
            RevObject revObject = rw.parseAny((AnyObjectId)objectId);
            return revObject;
        }
        finally {
            rw.release();
        }
    }
}

