/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.clone.ProjectUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

class BranchProjectTracker {
    private static final String PREFIX = "BranchProjectTracker_";
    private static final String KEY_PROJECTS = "projects";
    private static final String KEY_PROJECT = "project";
    private static final String KEY_BRANCH = "branch";
    private static final String REPO_ROOT = "/";
    private final Repository repository;

    public BranchProjectTracker(Repository repository) {
        this.repository = repository;
    }

    private String getBranch() {
        try {
            return this.repository.getBranch();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getPreference(String branch) {
        if (branch == null) {
            throw new IllegalArgumentException("Branch cannot be null");
        }
        if (branch.length() == 0) {
            throw new IllegalArgumentException("Branch cannot be empty");
        }
        return "BranchProjectTracker__" + this.repository.getDirectory().getAbsolutePath() + '_' + branch;
    }

    public IMemento snapshot() {
        IProject[] projects;
        String branch = this.getBranch();
        if (branch == null) {
            return null;
        }
        try {
            projects = ProjectUtil.getValidOpenProjects((Repository)this.repository);
        }
        catch (CoreException coreException) {
            return null;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_PROJECTS);
        memento.putString(KEY_BRANCH, branch);
        String workDir = this.repository.getWorkTree().getAbsolutePath();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String fullPath;
            IProject project = iProjectArray[n2];
            IPath path = project.getLocation();
            if (path != null && RepositoryProvider.getProvider((IProject)project) instanceof GitProvider && (fullPath = path.toOSString()).startsWith(workDir)) {
                String relative = fullPath.substring(workDir.length());
                if (relative.length() == 0) {
                    relative = REPO_ROOT;
                }
                IMemento child = memento.createChild(KEY_PROJECT);
                child.putTextData(relative);
            }
            ++n2;
        }
        return memento;
    }

    public BranchProjectTracker save(IMemento memento) {
        if (!(memento instanceof XMLMemento)) {
            throw new IllegalArgumentException("Invalid memento");
        }
        String branch = memento.getString(KEY_BRANCH);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String pref = this.getPreference(branch);
        StringWriter writer = new StringWriter();
        try {
            ((XMLMemento)memento).save((Writer)writer);
            store.setValue(pref, writer.toString());
        }
        catch (IOException e) {
            Activator.logError("Error writing branch-project associations", e);
        }
        return this;
    }

    public String[] getProjectPaths() {
        String branch = this.getBranch();
        if (branch == null) {
            return new String[0];
        }
        return this.getProjectPaths(branch);
    }

    public String[] getProjectPaths(String branch) {
        XMLMemento memento;
        String pref = this.getPreference(branch);
        String value = Activator.getDefault().getPreferenceStore().getString(pref);
        if (value.length() == 0) {
            return new String[0];
        }
        try {
            memento = XMLMemento.createReadRoot((Reader)new StringReader(value));
        }
        catch (WorkbenchException e) {
            Activator.logError("Error reading branch-project associations", e);
            return new String[0];
        }
        IMemento[] children = memento.getChildren(KEY_PROJECT);
        if (children.length == 0) {
            return new String[0];
        }
        ArrayList<String> projects = new ArrayList<String>(children.length);
        int i = 0;
        while (i < children.length) {
            String path = children[i].getTextData();
            if (path != null && path.length() > 0) {
                projects.add(path);
            }
            ++i;
        }
        return projects.toArray(new String[projects.size()]);
    }

    public void restore(IProgressMonitor monitor) {
        String branch = this.getBranch();
        if (branch != null) {
            this.restore(branch, monitor);
        }
    }

    public void restore(String branch, IProgressMonitor monitor) {
        String[] paths = this.getProjectPaths(branch);
        if (paths.length == 0) {
            return;
        }
        LinkedHashSet<ProjectRecord> records = new LinkedHashSet<ProjectRecord>();
        File parent = this.repository.getWorkTree();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File projectDescription;
            String path = stringArray[n2];
            File root = !REPO_ROOT.equals(path) ? new File(parent, path) : parent;
            if (root.isDirectory() && (projectDescription = new File(root, ".project")).isFile()) {
                records.add(new ProjectRecord(projectDescription));
            }
            ++n2;
        }
        if (records.isEmpty()) {
            return;
        }
        Object importMonitor = monitor != null ? monitor : new NullProgressMonitor();
        try {
            ProjectUtils.createProjects(records, true, this.repository, null, importMonitor);
        }
        catch (InvocationTargetException e) {
            Activator.logError("Error restoring branch-project associations", e);
        }
        catch (InterruptedException interruptedException) {}
    }
}

