/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.RebaseTargetSelectionDialog;
import org.eclipse.egit.ui.internal.rebase.RebaseHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class RebaseCurrentRefCommand
extends AbstractRebaseCommandHandler {
    public RebaseCurrentRefCommand() {
        super(null, null, null);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Ref ref;
        ISelection currentSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            Object selected = selection.getFirstElement();
            ref = this.getRef(selected);
        } else {
            ref = null;
        }
        Repository repository = this.getRepository(event);
        BasicConfigurationDialog.show(repository);
        try {
            if (ref != null && ref.getName().equals(repository.getFullBranch())) {
                ref = null;
            }
        }
        catch (IOException iOException) {}
        if (ref == null) {
            RebaseTargetSelectionDialog rebaseTargetSelectionDialog = new RebaseTargetSelectionDialog(this.getShell(event), repository);
            if (rebaseTargetSelectionDialog.open() == 0) {
                String refName = rebaseTargetSelectionDialog.getRefName();
                try {
                    ref = repository.getRef(refName);
                }
                catch (IOException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            } else {
                return null;
            }
        }
        String jobname = NLS.bind((String)UIText.RebaseCurrentRefCommand_RebasingCurrentJobName, (Object)ref.getName());
        RebaseHelper.runRebaseJob(repository, jobname, ref);
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext ctx;
        Object selection;
        if (evaluationContext instanceof IEvaluationContext && (selection = (ctx = (IEvaluationContext)evaluationContext).getVariable("activeMenuSelection")) instanceof ISelection) {
            Repository repo = this.getRepository((ISelection)selection);
            if (repo != null) {
                boolean isSafe = repo.getRepositoryState() == RepositoryState.SAFE;
                this.setBaseEnabled(isSafe && this.hasHead(repo));
            } else {
                this.setBaseEnabled(false);
            }
            return;
        }
        this.setBaseEnabled(true);
    }

    private boolean hasHead(Repository repo) {
        try {
            return repo.getRef("HEAD").getObjectId() != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

