/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;

public class RefSpecWizard
extends Wizard {
    private final boolean pushMode;
    private final RemoteConfig config;
    private RefSpecPage page;

    public RefSpecWizard(Repository repository, RemoteConfig config, boolean pushMode) {
        this.setNeedsProgressMonitor(true);
        this.pushMode = pushMode;
        this.config = config;
        this.page = new RefSpecPage(repository, pushMode);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public IWizardPage getStartingPage() {
        this.page.setSelection(new RepositorySelection(null, this.config));
        return super.getStartingPage();
    }

    public boolean performFinish() {
        if (this.pushMode) {
            this.config.setPushRefSpecs(this.page.getRefSpecs());
        } else {
            this.config.setFetchRefSpecs(this.page.getRefSpecs());
            this.config.setTagOpt(this.page.getTagOpt());
        }
        return true;
    }
}

