/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.transport.RemoteConfig;

public class RepositoriesViewPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        RemoteConfig rconfig;
        String configName;
        Ref ref;
        if (!(receiver instanceof RepositoryTreeNode)) {
            return false;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)receiver;
        if (property.equals("isBare")) {
            return node.getRepository().isBare();
        }
        if (property.equals("containsHead")) {
            return this.containsHead(node);
        }
        if (property.equals("isSafe")) {
            return node.getRepository().getRepositoryState() == RepositoryState.SAFE;
        }
        if (property.equals("isRefCheckedOut")) {
            block30: {
                block29: {
                    if (!(node.getObject() instanceof Ref)) {
                        return false;
                    }
                    ref = (Ref)node.getObject();
                    try {
                        if (ref.getName().startsWith("refs/")) {
                            return ref.getName().equals(node.getRepository().getFullBranch());
                        }
                        if (!ref.getName().equals("HEAD")) break block29;
                        return true;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
                String leafname = ref.getLeaf().getName();
                if (!leafname.startsWith("refs/") || !leafname.equals(node.getRepository().getFullBranch())) break block30;
                return true;
            }
            ref.getLeaf().getObjectId().equals((AnyObjectId)node.getRepository().resolve("HEAD"));
        }
        if (property.equals("isLocalBranch")) {
            if (!(node.getObject() instanceof Ref)) {
                return false;
            }
            ref = (Ref)node.getObject();
            return ref.getName().startsWith("refs/heads/");
        }
        if (property.equals("fetchExists") && node instanceof RemoteNode) {
            configName = (String)((RemoteNode)node).getObject();
            try {
                rconfig = new RemoteConfig((Config)node.getRepository().getConfig(), configName);
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
            return !rconfig.getFetchRefSpecs().isEmpty() && !rconfig.getURIs().isEmpty();
        }
        if (property.equals("pushExists") && node instanceof RemoteNode) {
            configName = (String)((RemoteNode)node).getObject();
            try {
                rconfig = new RemoteConfig((Config)node.getRepository().getConfig(), configName);
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
            return !rconfig.getPushRefSpecs().isEmpty() && (!rconfig.getPushURIs().isEmpty() || !rconfig.getURIs().isEmpty());
        }
        if (property.equals("canMerge")) {
            String branch;
            block31: {
                Repository rep = node.getRepository();
                if (rep.getRepositoryState() != RepositoryState.SAFE) {
                    return false;
                }
                try {
                    branch = rep.getFullBranch();
                    if (branch != null) break block31;
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return branch.startsWith("refs/heads/");
        }
        if (property.equals("canAbortRebase")) {
            switch (node.getRepository().getRepositoryState()) {
                case REBASING_INTERACTIVE: {
                    return true;
                }
            }
            return false;
        }
        if ("isSubmodule".equals(property)) {
            RepositoryTreeNode parent = node.getParent();
            return parent != null && parent.getType() == RepositoryTreeNodeType.SUBMODULES;
        }
        return false;
    }

    private boolean containsHead(RepositoryTreeNode node) {
        try {
            return node.getRepository().resolve("HEAD") != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

