/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateBranchCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        if (node.getType() == RepositoryTreeNodeType.ADDITIONALREF) {
            Ref ref = (Ref)node.getObject();
            try {
                RevCommit baseCommit = new RevWalk(node.getRepository()).parseCommit((AnyObjectId)ref.getLeaf().getObjectId());
                WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)new CreateBranchWizard(node.getRepository(), baseCommit.name()));
                dlg.setHelpAvailable(false);
                dlg.open();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            return null;
        }
        String base = null;
        if (node.getObject() instanceof Ref) {
            base = ((Ref)node.getObject()).getName();
        } else {
            Object branch;
            try {
                String ref;
                branch = node.getRepository().getFullBranch().startsWith("refs/heads/") ? node.getRepository().getRef(node.getRepository().getFullBranch()) : ((ref = Activator.getDefault().getRepositoryUtil().mapCommitToRef(node.getRepository(), node.getRepository().getFullBranch(), false)) == null ? null : (ref.startsWith("refs/tags/") ? null : node.getRepository().getRef(ref)));
            }
            catch (IOException iOException) {
                branch = null;
            }
            if (branch != null) {
                base = branch.getName();
            }
        }
        new WizardDialog(this.getShell(event), (IWizard)new CreateBranchWizard(node.getRepository(), base)).open();
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.enableWhenRepositoryHaveHead(evaluationContext);
    }
}

