/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.tree.FetchNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.StoredConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteFetchCommand
extends RepositoriesViewCommandHandler<FetchNode> {
    private static final String REMOTE = "remote";
    private static final String FETCH = "fetch";
    private static final String PUSH = "push";
    private static final String URL = "url";
    private static final String PUSHURL = "pushurl";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FetchNode node = (FetchNode)this.getSelectedNodes(event).get(0);
        RemoteNode remote = (RemoteNode)node.getParent();
        StoredConfig config = node.getRepository().getConfig();
        String fetchUrl = config.getString(REMOTE, (String)remote.getObject(), URL);
        config.unset(REMOTE, (String)remote.getObject(), FETCH);
        config.unset(REMOTE, (String)remote.getObject(), URL);
        if (fetchUrl != null) {
            String[] pushurls;
            boolean hasPush;
            boolean bl = hasPush = config.getStringList(REMOTE, (String)remote.getObject(), PUSH).length > 0;
            if (hasPush && (pushurls = config.getStringList(REMOTE, (String)remote.getObject(), PUSHURL)).length == 0) {
                config.setString(REMOTE, (String)remote.getObject(), PUSHURL, fetchUrl);
            }
        }
        try {
            config.save();
        }
        catch (IOException e1) {
            Activator.handleError(e1.getMessage(), e1, true);
        }
        return null;
    }
}

