/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.submodule;

import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.submodule.SubmodulePathWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;

public class AddSubmoduleWizard
extends Wizard {
    private final Repository repo;
    private SubmodulePathWizardPage pathPage;
    private RepositorySelectionPage uriPage;

    public AddSubmoduleWizard(Repository repo) {
        this.repo = repo;
        this.setWindowTitle(UIText.AddSubmoduleWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
    }

    public void addPages() {
        this.pathPage = new SubmodulePathWizardPage(this.repo);
        this.addPage((IWizardPage)this.pathPage);
        this.uriPage = new RepositorySelectionPage(true, null);
        this.uriPage.setPageComplete(false);
        this.addPage((IWizardPage)this.uriPage);
    }

    public String getPath() {
        return this.pathPage.getPath();
    }

    public URIish getUri() {
        return this.uriPage.getSelection().getURI();
    }

    public boolean performFinish() {
        return !this.uriPage.getStoreInSecureStore() || SecureStoreUtils.storeCredentials(this.uriPage.getCredentials(), this.uriPage.getSelection().getURI());
    }
}

