/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.action;

import java.io.File;
import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GitOpenInCompareAction
extends Action {
    private final Action oldAction;
    private final ISynchronizePageConfiguration conf;

    public GitOpenInCompareAction(ISynchronizePageConfiguration configuration, Action oldAction) {
        this.conf = configuration;
        this.oldAction = oldAction;
    }

    public void run() {
        ISelection selection = this.conf.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            boolean reuseEditor = sel.size() == 1;
            for (Object obj : sel) {
                if (obj instanceof GitModelBlob) {
                    this.handleGitObjectComparison((GitModelBlob)((Object)obj), reuseEditor);
                    continue;
                }
                this.oldAction.run();
                break;
            }
        }
    }

    private void handleGitObjectComparison(GitModelBlob obj, boolean reuseEditor) {
        ITypedElement right;
        Object left;
        IFile file = (IFile)obj.getResource();
        if (obj instanceof GitModelWorkingFile) {
            left = file.getLocation() == null ? new LocalNonWorkspaceTypedElement(file.getFullPath().toString()) : SaveableCompareEditorInput.createFileElement((IFile)file);
            right = this.getCachedFileElement(file);
        } else if (obj instanceof GitModelCacheFile) {
            left = this.getCachedFileElement(file);
            right = this.getHeadFileElement(obj);
        } else {
            this.oldAction.run();
            return;
        }
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput((ITypedElement)left, right, null);
        IWorkbenchPage page = GitOpenInCompareAction.getWorkbenchPage(this.conf.getSite());
        OpenInCompareAction.openCompareEditor((CompareEditorInput)in, (IWorkbenchPage)page, (boolean)reuseEditor);
    }

    private static IWorkbenchPage getWorkbenchPage(ISynchronizePageSite site) {
        IWorkbenchPage page = null;
        if (site == null || site.getWorkbenchSite() == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        } else {
            page = site.getWorkbenchSite().getPage();
        }
        return page;
    }

    private ITypedElement getCachedFileElement(IFile file) {
        try {
            return CompareUtils.getHeadTypedElement(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ITypedElement getHeadFileElement(GitModelBlob blob) {
        Repository repo = blob.getRepository();
        String gitPath = Repository.stripWorkDir((File)repo.getWorkTree(), (File)blob.getLocation().toFile());
        return CompareUtils.getFileRevisionTypedElement(gitPath, blob.getBaseCommit(), repo);
    }
}

