/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitModelRepository
extends GitModelObject {
    private final Repository repo;
    private final RevCommit srcRev;
    private final RevCommit dstRev;
    private final Set<IProject> projects;
    private final TreeFilter pathFilter;
    private final boolean includeLocal;
    private IPath location;

    public GitModelRepository(GitSynchronizeData data) throws MissingObjectException, IOException {
        super(null);
        this.repo = data.getRepository();
        this.includeLocal = data.shouldIncludeLocal();
        this.projects = data.getProjects();
        this.pathFilter = data.getPathFilter();
        this.srcRev = data.getSrcRevCommit();
        this.dstRev = data.getDstRevCommit();
    }

    @Override
    public GitModelObject[] getChildren() {
        ArrayList<GitModelObjectContainer> result = new ArrayList<GitModelObjectContainer>();
        if (this.srcRev != null && this.dstRev != null) {
            result.addAll(this.getListOfCommit());
        } else {
            GitModelWorkingTree changes = this.getLocaWorkingTreeChanges();
            if (changes != null) {
                result.add(changes);
            }
        }
        return result.toArray(new GitModelObjectContainer[result.size()]);
    }

    @Override
    public String getName() {
        return this.repo.getWorkTree().toString();
    }

    @Override
    public IProject[] getProjects() {
        return this.projects.toArray(new IProject[this.projects.size()]);
    }

    @Override
    public Repository getRepository() {
        return this.repo;
    }

    public ObjectId getSrcRev() {
        return this.srcRev;
    }

    public ObjectId getDstRev() {
        return this.dstRev;
    }

    @Override
    public IPath getLocation() {
        if (this.location == null) {
            this.location = new Path(this.repo.getWorkTree().toString());
        }
        return this.location;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitModelRepository) {
            File objWorkTree = ((GitModelRepository)((Object)obj)).repo.getWorkTree();
            return objWorkTree.equals(this.repo.getWorkTree());
        }
        return false;
    }

    public int hashCode() {
        return this.repo.getWorkTree().hashCode();
    }

    public String toString() {
        return "ModelRepository[" + this.repo.getWorkTree() + "]";
    }

    private List<GitModelObjectContainer> getListOfCommit() {
        ArrayList<GitModelObjectContainer> result = new ArrayList<GitModelObjectContainer>();
        RevWalk rw = new RevWalk(this.repo);
        rw.setRetainBody(true);
        if (this.pathFilter != null) {
            rw.setTreeFilter(this.pathFilter);
        }
        try {
            RevCommit srcCommit = rw.parseCommit((AnyObjectId)this.srcRev);
            if (this.includeLocal) {
                int gitWorkingTreeLen;
                GitModelCache gitCache = new GitModelCache((GitModelObject)this, srcCommit, this.pathFilter);
                int gitCacheLen = gitCache.getChildren().length;
                GitModelWorkingTree gitWorkingTree = this.getLocaWorkingTreeChanges();
                int n = gitWorkingTreeLen = gitWorkingTree != null ? gitWorkingTree.getChildren().length : 0;
                if (gitCacheLen > 0 || gitWorkingTreeLen > 0) {
                    result.add(gitCache);
                    result.add(gitWorkingTree);
                }
            }
            if (this.srcRev.equals((AnyObjectId)this.dstRev)) {
                return result;
            }
            RevFlag localFlag = rw.newFlag("local");
            RevFlag remoteFlag = rw.newFlag("remote");
            RevFlagSet allFlags = new RevFlagSet();
            allFlags.add(localFlag);
            allFlags.add(remoteFlag);
            rw.carry((Collection)allFlags);
            srcCommit.add(localFlag);
            rw.markStart(srcCommit);
            RevCommit dstCommit = rw.parseCommit((AnyObjectId)this.dstRev);
            dstCommit.add(remoteFlag);
            rw.markStart(dstCommit);
            for (RevCommit nextCommit : rw) {
                if (!nextCommit.hasAll(allFlags)) {
                    if (nextCommit.has(localFlag)) {
                        result.add(new GitModelCommit(this, nextCommit, 8, this.pathFilter));
                        continue;
                    }
                    if (!nextCommit.has(remoteFlag)) continue;
                    result.add(new GitModelCommit(this, nextCommit, 4, this.pathFilter));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private GitModelWorkingTree getLocaWorkingTreeChanges() {
        try {
            return new GitModelWorkingTree((GitModelObject)this, this.pathFilter);
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

