/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lock;

import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDurableLockingManager {
    public LockArea createLockArea(String var1, CDOBranchPoint var2, boolean var3, Map<CDOID, LockGrade> var4);

    public LockArea getLockArea(String var1) throws LockAreaNotFoundException;

    public void getLockAreas(String var1, LockArea.Handler var2);

    public void deleteLockArea(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LockArea
    extends CDOBranchPoint {
        public String getDurableLockingID();

        public String getUserID();

        public boolean isReadOnly();

        public Map<CDOID, LockGrade> getLocks();

        public static interface Handler {
            public boolean handleLockArea(LockArea var1);
        }
    }

    public static class LockAreaNotFoundException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;
        private String durableLockingID;

        public LockAreaNotFoundException(String durableLockingID) {
            super("No lock area for ID=" + durableLockingID);
            this.durableLockingID = durableLockingID;
        }

        public LockAreaNotFoundException(String message, Throwable cause, String durableLockingID) {
            super(message, cause);
            this.durableLockingID = durableLockingID;
        }

        public String getDurableLockingID() {
            return this.durableLockingID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockGrade {
        NONE(0),
        READ(1),
        WRITE(2),
        READ_WRITE(READ.getValue() | WRITE.getValue());

        private final int value;

        private LockGrade(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isRead() {
            return (this.value & 1) != 0;
        }

        public boolean isWrite() {
            return (this.value & 2) != 0;
        }

        public LockGrade getUpdated(IRWLockManager.LockType type, boolean on) {
            int mask;
            int n = mask = type == IRWLockManager.LockType.READ ? 1 : 2;
            if (on) {
                return LockGrade.get(this.value | mask);
            }
            return LockGrade.get(this.value & ~mask);
        }

        public static LockGrade get(IRWLockManager.LockType type) {
            if (type == IRWLockManager.LockType.READ) {
                return READ;
            }
            if (type == IRWLockManager.LockType.WRITE) {
                return WRITE;
            }
            return NONE;
        }

        public static LockGrade get(boolean read, boolean write) {
            return LockGrade.get((read ? 1 : 0) | (write ? 2 : 0));
        }

        public static LockGrade get(int value) {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return READ;
                }
                case 2: {
                    return WRITE;
                }
                case 3: {
                    return READ_WRITE;
                }
            }
            throw new IllegalArgumentException("Invalid lock grade: " + value);
        }
    }
}

