/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOFetchRule {
    private EClass eClass;
    private List<EStructuralFeature> features = new ArrayList<EStructuralFeature>(0);

    public CDOFetchRule(EClass eClass) {
        this.eClass = eClass;
    }

    public CDOFetchRule(CDODataInput in, CDOPackageRegistry packageManager) throws IOException {
        this.eClass = (EClass)in.readCDOClassifierRefAndResolve();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            int featureID = in.readInt();
            EStructuralFeature feature = this.eClass.getEStructuralFeature(featureID);
            this.features.add(feature);
            ++i;
        }
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOClassifierRef((EClassifier)this.eClass);
        out.writeInt(this.features.size());
        for (EStructuralFeature feature : this.features) {
            out.writeInt(feature.getFeatureID());
        }
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public List<EStructuralFeature> getFeatures() {
        return this.features;
    }

    public void addFeature(EStructuralFeature feature) {
        this.features.add(feature);
    }

    public void removeFeature(EStructuralFeature feature) {
        this.features.remove(feature);
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }
}

