/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeKindCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOChangeSetDataImpl
implements CDOChangeSetData {
    private List<CDOIDAndVersion> newObjects;
    private List<CDORevisionKey> changedObjects;
    private List<CDOIDAndVersion> detachedObjects;
    private CDOChangeKindCache changeKindCache;

    public CDOChangeSetDataImpl(List<CDOIDAndVersion> newObjects, List<CDORevisionKey> changedObjects, List<CDOIDAndVersion> detachedObjects) {
        this.newObjects = newObjects;
        this.changedObjects = changedObjects;
        this.detachedObjects = detachedObjects;
    }

    public CDOChangeSetDataImpl() {
        this(new ArrayList<CDOIDAndVersion>(), new ArrayList<CDORevisionKey>(), new ArrayList<CDOIDAndVersion>());
    }

    @Override
    public boolean isEmpty() {
        if (this.newObjects != null && !this.newObjects.isEmpty()) {
            return false;
        }
        if (this.changedObjects != null && !this.changedObjects.isEmpty()) {
            return false;
        }
        return this.detachedObjects == null || this.detachedObjects.isEmpty();
    }

    @Override
    public CDOChangeSetData copy() {
        ArrayList<CDOIDAndVersion> newObjectsCopy = new ArrayList<CDOIDAndVersion>(this.newObjects.size());
        for (CDOIDAndVersion key : this.newObjects) {
            if (key instanceof CDORevision) {
                CDORevision revision = (CDORevision)key;
                newObjectsCopy.add(revision.copy());
                continue;
            }
            newObjectsCopy.add(key);
        }
        ArrayList<CDORevisionKey> changedObjectsCopy = new ArrayList<CDORevisionKey>(this.changedObjects.size());
        for (CDORevisionKey key : this.changedObjects) {
            if (key instanceof CDORevisionDelta) {
                CDORevisionDelta delta = (CDORevisionDelta)key;
                changedObjectsCopy.add(delta.copy());
                continue;
            }
            changedObjectsCopy.add(key);
        }
        ArrayList<CDOIDAndVersion> detachedObjectsCopy = new ArrayList<CDOIDAndVersion>(this.detachedObjects.size());
        for (CDOIDAndVersion key : this.detachedObjects) {
            detachedObjectsCopy.add(key);
        }
        return new CDOChangeSetDataImpl(newObjectsCopy, changedObjectsCopy, detachedObjectsCopy);
    }

    @Override
    public void merge(CDOChangeSetData changeSetData) {
        HashMap<CDOID, CDOIDAndVersion> newMap = new HashMap<CDOID, CDOIDAndVersion>();
        CDOChangeSetDataImpl.fillMap(newMap, this.newObjects);
        CDOChangeSetDataImpl.fillMap(newMap, changeSetData.getNewObjects());
        HashMap<CDOID, CDORevisionKey> changedMap = new HashMap<CDOID, CDORevisionKey>();
        CDOChangeSetDataImpl.fillMap(changedMap, this.changedObjects);
        for (CDORevisionKey key : changeSetData.getChangedObjects()) {
            this.mergeChangedObject(key, newMap, changedMap);
        }
        HashMap<CDOID, CDOIDAndVersion> detachedMap = new HashMap<CDOID, CDOIDAndVersion>();
        CDOChangeSetDataImpl.fillMap(detachedMap, this.detachedObjects);
        for (CDOIDAndVersion key : changeSetData.getDetachedObjects()) {
            CDOID id = key.getID();
            if (newMap.remove(id) != null) continue;
            detachedMap.put(id, key);
        }
        this.newObjects = new ArrayList(newMap.values());
        this.changedObjects = new ArrayList(changedMap.values());
        this.detachedObjects = new ArrayList(detachedMap.values());
    }

    private void mergeChangedObject(CDORevisionKey key, Map<CDOID, CDOIDAndVersion> newMap, Map<CDOID, CDORevisionKey> changedMap) {
        CDOID id = key.getID();
        if (key instanceof CDORevisionDelta) {
            CDORevisionDelta delta = (CDORevisionDelta)key;
            CDOIDAndVersion oldRevision = newMap.get(id);
            if (oldRevision instanceof CDORevision) {
                CDORevision newRevision = (CDORevision)oldRevision;
                delta.apply(newRevision);
                return;
            }
            CDORevisionKey oldDelta = changedMap.get(id);
            if (oldDelta instanceof CDORevisionDelta) {
                InternalCDORevisionDelta newDelta = (InternalCDORevisionDelta)oldDelta;
                for (CDOFeatureDelta featureDelta : delta.getFeatureDeltas()) {
                    newDelta.addFeatureDelta(featureDelta);
                }
                return;
            }
        }
        changedMap.put(id, key);
    }

    @Override
    public List<CDOIDAndVersion> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public List<CDORevisionKey> getChangedObjects() {
        return this.changedObjects;
    }

    @Override
    public List<CDOIDAndVersion> getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public synchronized CDOChangeKind getChangeKind(CDOID id) {
        if (this.changeKindCache == null) {
            this.changeKindCache = new CDOChangeKindCache(this);
        }
        return this.changeKindCache.getChangeKind(id);
    }

    public String toString() {
        return MessageFormat.format("ChangeSetData[newObjects={0}, changedObjects={1}, detachedObjects={2}]", this.newObjects.size(), this.changedObjects.size(), this.detachedObjects.size());
    }

    private static <T extends CDOIDAndVersion> void fillMap(Map<CDOID, T> map, Collection<T> c) {
        for (CDOIDAndVersion key : c) {
            map.put(key.getID(), key);
        }
    }
}

