/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongImpl;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public class CDOIDObjectLongWithClassifierImpl
extends CDOIDObjectLongImpl
implements CDOClassifierRef.Provider {
    private static final long serialVersionUID = 1L;
    private CDOClassifierRef classifierRef;

    public CDOIDObjectLongWithClassifierImpl() {
    }

    public CDOIDObjectLongWithClassifierImpl(CDOClassifierRef classifierRef, long value) {
        super(value);
        this.classifierRef = classifierRef;
    }

    public CDOClassifierRef getClassifierRef() {
        return this.classifierRef;
    }

    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.LONG_WITH_CLASSIFIER;
    }

    public String toURIFragment() {
        return String.valueOf(this.getClassifierRef().getPackageURI()) + "#" + this.getClassifierRef().getClassifierName() + "#" + super.toURIFragment();
    }

    public void read(String fragmentPart) {
        int index1 = fragmentPart.indexOf("#");
        int index2 = fragmentPart.indexOf("#", index1 + 1);
        if (index1 == -1 || index2 == -1) {
            throw new IllegalArgumentException("The fragment " + fragmentPart + " is not a valid fragment");
        }
        this.classifierRef = new CDOClassifierRef(fragmentPart.substring(0, index1), fragmentPart.substring(index1 + 1, index2));
        super.read(fragmentPart.substring(index2 + 1));
    }

    public void read(ExtendedDataInput in) throws IOException {
        CDODataInput cdoDataInput = (CDODataInput)in;
        this.classifierRef = cdoDataInput.readCDOClassifierRef();
        super.read(in);
    }

    public void write(ExtendedDataOutput out) throws IOException {
        CDODataOutput cdoDataOutput = (CDODataOutput)out;
        cdoDataOutput.writeCDOClassifierRef(this.classifierRef);
        super.write(out);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CDOIDObjectLongWithClassifierImpl that = (CDOIDObjectLongWithClassifierImpl)obj;
            return ObjectUtil.equals((Object)this.classifierRef, (Object)that.classifierRef) && this.getLongValue() == that.getLongValue();
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.classifierRef.hashCode() ^ ObjectUtil.hashCode((long)this.getLongValue());
        return this.getClass().hashCode() ^ hashCode;
    }

    public String toString() {
        return "OID:" + this.toURIFragment();
    }

    protected int doCompareTo(CDOID o) throws ClassCastException {
        return this.toURIFragment().compareTo(o.toURIFragment());
    }
}

