/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOClassInfoImpl
extends AdapterImpl
implements CDOClassInfo {
    private static final int NOT_MAPPED = -1;
    private EStructuralFeature[] allPersistentFeatures;
    private int[] featureIDMappings;

    public boolean isAdapterForType(Object type) {
        return type == CDOClassInfo.class;
    }

    public void setTarget(Notifier newTarget) {
        this.init((EClass)newTarget);
        super.setTarget(newTarget);
    }

    public EClass getEClass() {
        return (EClass)this.getTarget();
    }

    public boolean isResource() {
        return CDOModelUtil.isResource(this.getEClass());
    }

    public boolean isResourceFolder() {
        return CDOModelUtil.isResourceFolder(this.getEClass());
    }

    public boolean isResourceNode() {
        return CDOModelUtil.isResourceNode(this.getEClass());
    }

    public EStructuralFeature[] getAllPersistentFeatures() {
        return this.allPersistentFeatures;
    }

    public int getFeatureIndex(EStructuralFeature feature) {
        int featureID = this.getEClass().getFeatureID(feature);
        return this.getFeatureIndex(featureID);
    }

    public int getFeatureIndex(int featureID) {
        int index = this.featureIDMappings[featureID];
        if (index == -1) {
            throw new IllegalArgumentException("Feature not mapped: " + this.getEClass().getEStructuralFeature(featureID));
        }
        return index;
    }

    private void init(EClass eClass) {
        ArrayList<EStructuralFeature> persistentFeatures = new ArrayList<EStructuralFeature>();
        EList allFeatures = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : allFeatures) {
            if (!EMFUtil.isPersistent(feature)) continue;
            persistentFeatures.add(feature);
        }
        this.allPersistentFeatures = persistentFeatures.toArray(new EStructuralFeature[persistentFeatures.size()]);
        this.featureIDMappings = new int[allFeatures.size()];
        Arrays.fill(this.featureIDMappings, -1);
        int i = 0;
        while (i < this.allPersistentFeatures.length) {
            EStructuralFeature feature = this.allPersistentFeatures[i];
            int featureID = eClass.getFeatureID(feature);
            this.featureIDMappings[featureID] = i++;
        }
    }

    public String toString() {
        return this.getEClass().toString();
    }
}

