/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.AbstractCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionCacheAuditing
extends AbstractCDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, CDORevisionCacheAuditing.class);
    protected Map<Object, RevisionList> revisionLists = new HashMap<Object, RevisionList>();

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        return new CDORevisionCacheAuditing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EClass getObjectType(CDOID id) {
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            Reference ref;
            InternalCDORevision revision;
            RevisionList revisionList = this.revisionLists.get(id);
            if (revisionList != null && !revisionList.isEmpty() && (revision = (InternalCDORevision)(ref = (Reference)revisionList.getFirst()).get()) != null) {
                return revision.getEClass();
            }
            return null;
        }
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        RevisionList revisionList = this.getRevisionList(id, branchPoint.getBranch());
        if (revisionList != null) {
            return revisionList.getRevision(branchPoint.getTimeStamp());
        }
        return null;
    }

    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        RevisionList revisionList = this.getRevisionList(id, branchVersion.getBranch());
        if (revisionList != null) {
            return revisionList.getRevisionByVersion(branchVersion.getVersion());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> currentRevisions = new ArrayList<CDORevision>();
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (RevisionList revisionList : this.revisionLists.values()) {
                InternalCDORevision revision = revisionList.getRevision(0L);
                if (revision == null) continue;
                currentRevisions.add(revision);
            }
        }
        return currentRevisions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (RevisionList list : this.revisionLists.values()) {
                list.getAllRevisions(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        ArrayList<CDORevision> result = new ArrayList<CDORevision>();
        CDOBranch branch = branchPoint.getBranch();
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (Map.Entry<Object, RevisionList> entry : this.revisionLists.entrySet()) {
                RevisionList list;
                InternalCDORevision revision;
                if (!this.isKeyInBranch(entry.getKey(), branch) || (revision = (list = entry.getValue()).getRevision(branchPoint.getTimeStamp())) == null) continue;
                result.add(revision);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRevision(CDORevision revision) {
        CheckUtil.checkArg((Object)revision, (String)"revision");
        CDOID id = revision.getID();
        Object key = this.createKey(id, revision.getBranch());
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            RevisionList list = this.revisionLists.get(key);
            if (list == null) {
                list = new RevisionList();
                this.revisionLists.put(key, list);
            }
            list.addRevision((InternalCDORevision)revision, this.createReference(revision));
            this.typeRefIncrease(id, revision.getEClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        Object key = this.createKey(id, branchVersion.getBranch());
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            RevisionList list = this.revisionLists.get(key);
            if (list != null) {
                list.removeRevision(branchVersion.getVersion());
                if (list.isEmpty()) {
                    this.revisionLists.remove(key);
                    this.typeRefDecrease(id);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Removed cache list of {0}", new Object[]{key});
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            this.revisionLists.clear();
            this.typeRefDispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            return this.revisionLists.toString();
        }
    }

    protected void typeRefIncrease(CDOID id, EClass type) {
    }

    protected void typeRefDecrease(CDOID id) {
    }

    protected void typeRefDispose() {
    }

    protected Object createKey(CDOID id, CDOBranch branch) {
        return id;
    }

    protected boolean isKeyInBranch(Object key, CDOBranch branch) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RevisionList getRevisionList(CDOID id, CDOBranch branch) {
        Object key = this.createKey(id, branch);
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            return this.revisionLists.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class RevisionList
    extends LinkedList<Reference<InternalCDORevision>> {
        private static final long serialVersionUID = 1L;

        public synchronized InternalCDORevision getRevision(long timeStamp) {
            if (timeStamp == 0L) {
                Reference ref;
                Reference reference = ref = this.isEmpty() ? null : (Reference)this.getFirst();
                if (ref != null) {
                    InternalCDORevision revision = (InternalCDORevision)ref.get();
                    if (revision != null) {
                        if (!revision.isHistorical()) {
                            return revision;
                        }
                    } else {
                        this.removeFirst();
                    }
                }
                return null;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    long created = revision.getTimeStamp();
                    if (created > timeStamp) continue;
                    long revised = revision.getRevised();
                    if (timeStamp > revised && revised != 0L) break;
                    return revision;
                }
                it.remove();
            }
            return null;
        }

        public synchronized InternalCDORevision getRevisionByVersion(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    int v = revision.getVersion();
                    if (v == version) {
                        return revision;
                    }
                    if (v >= version) continue;
                    break;
                }
                it.remove();
            }
            return null;
        }

        public synchronized boolean addRevision(InternalCDORevision revision, Reference<InternalCDORevision> reference) {
            int version = revision.getVersion();
            ListIterator<Reference<InternalCDORevision>> it = this.listIterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                InternalCDORevision foundRevision = (InternalCDORevision)ref.get();
                if (foundRevision != null) {
                    CDORevisionKey key = (CDORevisionKey)((Object)ref);
                    int v = key.getVersion();
                    if (v == version) {
                        return false;
                    }
                    if (v >= version) continue;
                    it.previous();
                    it.add(reference);
                    return true;
                }
                it.remove();
            }
            this.addLast(reference);
            return true;
        }

        public synchronized void removeRevision(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                CDORevisionKey key = (CDORevisionKey)((Object)ref);
                int v = key.getVersion();
                if (v == version) {
                    it.remove();
                    if (!TRACER.isEnabled()) break;
                    TRACER.format("Removed version {0} from cache list of {1}", new Object[]{version, key.getID()});
                    break;
                }
                if (v < version) break;
            }
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (Reference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (buffer.length() == 0) {
                    buffer.append("{");
                } else {
                    buffer.append(", ");
                }
                buffer.append(revision);
            }
            buffer.append("}");
            return buffer.toString();
        }

        public void getAllRevisions(Map<CDOBranch, List<CDORevision>> result) {
            for (Reference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision == null) continue;
                CDOBranch branch = revision.getBranch();
                List<CDORevision> resultList = result.get(branch);
                if (resultList == null) {
                    resultList = new ArrayList<CDORevision>(1);
                    result.put(branch, resultList);
                }
                resultList.add(revision);
            }
        }
    }
}

