/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.revision.AbstractCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionCacheNonAuditing
extends AbstractCDORevisionCache {
    private Map<CDOID, Reference<InternalCDORevision>> revisions = new HashMap<CDOID, Reference<InternalCDORevision>>();

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        return new CDORevisionCacheNonAuditing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EClass getObjectType(CDOID id) {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            InternalCDORevision revision;
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null && (revision = ref.get()) != null) {
                return revision.getEClass();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            InternalCDORevision revision;
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null && (revision = ref.get()) != null && revision.isValid(branchPoint)) {
                return revision;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            InternalCDORevision revision;
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null && (revision = ref.get()) != null && revision.getVersion() == branchVersion.getVersion()) {
                return revision;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> currentRevisions = new ArrayList<CDORevision>();
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            for (Reference<InternalCDORevision> ref : this.revisions.values()) {
                InternalCDORevision revision = ref.get();
                if (revision == null || revision.isHistorical()) continue;
                currentRevisions.add(revision);
            }
        }
        return currentRevisions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            ArrayList<InternalCDORevision> list = new ArrayList<InternalCDORevision>();
            for (Reference<InternalCDORevision> ref : this.revisions.values()) {
                InternalCDORevision revision = ref.get();
                if (revision == null) continue;
                list.add(revision);
            }
            if (!list.isEmpty()) {
                result.put(((CDORevision)list.get(0)).getBranch(), list);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        ArrayList<CDORevision> result = new ArrayList<CDORevision>();
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            for (Reference<InternalCDORevision> ref : this.revisions.values()) {
                InternalCDORevision revision = ref.get();
                if (revision == null || !revision.isValid(branchPoint)) continue;
                result.add(revision);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRevision(CDORevision revision) {
        CheckUtil.checkArg((Object)revision, (String)"revision");
        if (!revision.isHistorical()) {
            Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
            synchronized (map) {
                this.revisions.put(revision.getID(), this.createReference(revision));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null) {
                InternalCDORevision revision = ref.get();
                if (revision != null) {
                    if (revision.getVersion() == branchVersion.getVersion()) {
                        this.revisions.remove(id);
                        return revision;
                    }
                } else {
                    this.revisions.remove(id);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            this.revisions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            return this.revisions.toString();
        }
    }
}

