/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.spi.common.revision.BaseCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDORevisionImpl
extends BaseCDORevision {
    private Object[] values;
    private transient boolean frozen;

    public CDORevisionImpl(EClass eClass) {
        super(eClass);
    }

    protected CDORevisionImpl(CDORevisionImpl source) {
        super(source);
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures(this.getEClass());
        this.initValues(features);
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            EClassifier classifier = feature.getEType();
            if (feature.isMany()) {
                InternalCDOList sourceList = (InternalCDOList)source.values[i];
                if (sourceList != null) {
                    this.setValue(i, (Object)sourceList.clone(classifier));
                }
            } else {
                CDOType type = CDOModelUtil.getType(feature);
                this.setValue(i, type.copyValue(source.values[i]));
            }
            ++i;
        }
    }

    public InternalCDORevision copy() {
        return new CDORevisionImpl(this);
    }

    protected void initValues(EStructuralFeature[] allPersistentFeatures) {
        this.values = new Object[allPersistentFeatures.length];
    }

    protected Object getValue(int featureIndex) {
        return this.values[featureIndex];
    }

    protected void setValue(int featureIndex, Object value) {
        this.checkFrozen(featureIndex, value);
        this.values[featureIndex] = value;
    }

    public void freeze() {
        this.frozen = true;
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures(this.getEClass());
        int i = 0;
        while (i < features.length) {
            InternalCDOList list;
            EStructuralFeature feature = features[i];
            if (feature.isMany() && (list = (InternalCDOList)this.values[i]) != null) {
                list.freeze();
            }
            ++i;
        }
    }

    private void checkFrozen(int featureIndex, Object value) {
        if (this.frozen) {
            boolean newIsEmptyList;
            Object oldValue = this.values[featureIndex];
            boolean bl = newIsEmptyList = value instanceof EList && ((EList)value).size() == 0;
            if (newIsEmptyList && oldValue == null) {
                return;
            }
            if (oldValue instanceof CDOIDTemp && value instanceof CDOID) {
                return;
            }
            throw new IllegalStateException("Cannot modify a frozen revision");
        }
    }
}

