/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.commit;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitInfoManagerImpl;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOCommitInfoUtil {
    private CDOCommitInfoUtil() {
    }

    public static InternalCDOCommitInfoManager createCommitInfoManager() {
        return new CDOCommitInfoManagerImpl();
    }

    public static void dump(PrintStream out, CDOChangeSetData changeSetData) {
        for (CDOIDAndVersion cDOIDAndVersion : changeSetData.getNewObjects()) {
            out.println("  + " + cDOIDAndVersion);
            if (!(cDOIDAndVersion instanceof InternalCDORevision)) continue;
            InternalCDORevision revision = (InternalCDORevision)cDOIDAndVersion;
            EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                Object value = revision.getValue(feature);
                CDOCommitInfoUtil.dumpFeature(out, feature, value);
                ++n2;
            }
        }
        for (CDORevisionKey cDORevisionKey : changeSetData.getChangedObjects()) {
            CDORevisionDelta delta = (CDORevisionDelta)cDORevisionKey;
            String name = delta.getEClass().getName();
            CDOID id = delta.getID();
            int branch = delta.getBranch().getID();
            int version = delta.getVersion();
            out.println(MessageFormat.format("  * {0}@{1}:{2}v{3}", name, id, branch, version));
            CDOCommitInfoUtil.dumpFeatureDeltas(out, delta.getFeatureDeltas());
        }
        for (CDOIDAndVersion cDOIDAndVersion : changeSetData.getDetachedObjects()) {
            out.println("  - " + cDOIDAndVersion);
        }
    }

    private static void dumpFeatureDeltas(PrintStream out, List<CDOFeatureDelta> featureDeltas) {
        for (CDOFeatureDelta featureDelta : featureDeltas) {
            if (featureDelta instanceof CDOListFeatureDelta) {
                CDOListFeatureDelta list = (CDOListFeatureDelta)featureDelta;
                CDOCommitInfoUtil.dumpFeatureDeltas(out, list.getListChanges());
                continue;
            }
            CDOCommitInfoUtil.dumpFeature(out, featureDelta.getFeature(), featureDelta);
        }
    }

    private static void dumpFeature(PrintStream out, EStructuralFeature feature, Object value) {
        out.println("    " + feature.getName() + " = " + value);
    }
}

