/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ecore.presentation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.editors.impl.DawnEMFEditorSupport;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.dawn.ui.DawnLabelProvider;
import org.eclipse.emf.cdo.dawn.ui.DawnSelectionViewerAdapterFactoryContentProvider;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class DawnEcoreEditor
extends EcoreEditor
implements IDawnEditor {
    private IDawnEditorSupport dawnEditorSupport = new DawnEMFEditorSupport((IDawnEditor)this);
    public static String ID = "org.eclipse.emf.cdo.dawn.ecore.presentation.DawnEcoreEditorID";

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof DawnEditorInput) {
            this.dawnEditorSupport.setView(((DawnEditorInput)input).getView());
            this.dawnEditorSupport.registerListeners();
        }
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInput(input);
        if (input instanceof DawnEditorInput) {
            CDOResource resource = ((DawnEditorInput)input).getResource();
            URI uri = URI.createURI((String)((DawnEditorInput)input).getURI().toString());
            if (resource == null || resource.cdoView() == null) {
                ResourceSet resourceSet = this.editingDomain.getResourceSet();
                CDOTransaction transaction = CDOConnectionUtil.instance.openCurrentTransaction(resourceSet, uri.toString());
                resource = (CDOResource)resourceSet.getResource(uri, true);
                if (resource == null || resource.cdoView() == null) {
                    resource = transaction.getOrCreateResource(uri.toString());
                }
            }
            ((DawnEditorInput)input).setResource(resource);
            this.dawnEditorSupport.setView(((DawnEditorInput)input).getView());
            this.dawnEditorSupport.registerListeners();
        }
    }

    public void createPages() {
        super.createPages();
        this.selectionViewer.setContentProvider((IContentProvider)new DawnSelectionViewerAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory, ((DawnEditorInput)this.getEditorInput()).getResource()));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new DawnLabelProvider((AdapterFactory)this.adapterFactory, this.dawnEditorSupport.getView(), this.selectionViewer));
        CDOResource resource = ((DawnEditorInput)this.getEditorInput()).getResource();
        this.selectionViewer.setInput((Object)resource.getResourceSet());
        this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        CDOView view = this.dawnEditorSupport.getView();
        if (view instanceof CDOTransaction) {
            if (view.hasConflict()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"conflict", (String)"Your Resource is in conflict and cannot be committed");
            } else {
                super.doSave(progressMonitor);
            }
        }
    }

    public String getContributorID() {
        return null;
    }

    public CDOView getView() {
        return this.dawnEditorSupport.getView();
    }

    public void setDirty() {
        this.dawnEditorSupport.setDirty(true);
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            this.dawnEditorSupport.close();
        }
    }

    public String getContributorId() {
        return ID;
    }

    public IDawnEditorSupport getDawnEditorSupport() {
        return this.dawnEditorSupport;
    }
}

