/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ecoretools.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.dawn.ecoretools.diagram.part.DawnEcoreCreationWizardPage;
import org.eclipse.emf.cdo.dawn.ecoretools.diagram.part.DawnEcoreDiagramEditorUtil;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.diagram.part.EcoreCreationWizard;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorUtil;
import org.eclipse.emf.ecoretools.diagram.part.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;

public class DawnEcoreCreationWizard
extends EcoreCreationWizard {
    private CDOView view;
    private DawnEcoreCreationWizardPage diagPage;

    public DawnEcoreCreationWizard() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = session.openTransaction();
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                if (DawnEcoreCreationWizard.this.diagPage.isNewModel()) {
                    DawnEcoreCreationWizard.this.diagram = EcoreDiagramEditorUtil.createDiagram((URI)DawnEcoreCreationWizard.this.diagPage.getDiagramModelURI(), (URI)DawnEcoreCreationWizard.this.diagPage.getDomainModelURI(), (IProgressMonitor)monitor);
                } else {
                    DawnEcoreCreationWizard.this.diagram = DawnEcoreDiagramEditorUtil.createDiagramOnly(DawnEcoreCreationWizard.this.diagPage.getDiagramModelURI(), DawnEcoreCreationWizard.this.diagPage.getDomainModelURI(), DawnEcoreCreationWizard.this.diagPage.getDiagramEObject(), DawnEcoreCreationWizard.this.diagPage.isInitialized(), monitor);
                }
                if (DawnEcoreCreationWizard.this.diagram != null) {
                    try {
                        DawnEcoreDiagramEditorUtil.openDiagram(DawnEcoreCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)DawnEcoreCreationWizard.this.getContainer().getShell(), (String)Messages.EcoreCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.EcoreCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EcoreDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void addPages() {
        this.diagPage = new DawnEcoreCreationWizardPage("NewEcoreToolsDiagram", this.getSelection(), this.view);
        this.diagPage.setTitle(Messages.EcoreCreationWizard_DiagramModelFilePageTitle);
        this.diagPage.setDescription(Messages.EcoreCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagPage);
    }

    public void dispose() {
        this.view.close();
    }

    public boolean canFinish() {
        return true;
    }

    public static boolean openDiagram(Resource diagram) throws PartInitException {
        String path = diagram.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), "org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorID") != null;
        }
        return false;
    }
}

