/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ecoretools.diagram.part;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.cdo.dawn.commands.CreateSemanticResourceRecordingCommand;
import org.eclipse.emf.cdo.dawn.ecoretools.diagram.part.DawnEcoreDiagramEditor;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.transaction.DawnGMFEditingDomainFactory;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecoretools.diagram.edit.commands.InitializeAndLayoutDiagramCommand;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorUtil;
import org.eclipse.emf.ecoretools.diagram.part.Messages;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DawnEcoreDiagramEditorUtil
extends EcoreDiagramEditorUtil {
    public static boolean openDiagram(Resource diagram) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return page.openEditor((IEditorInput)new DawnEditorInput(diagram.getURI()), DawnEcoreDiagramEditor.ID) != null;
    }

    public static void runWizard(Shell shell, Wizard wizard, String settingsKey) {
        IDialogSettings pluginDialogSettings = EcoreDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardDialogSettings = pluginDialogSettings.getSection(settingsKey);
        if (wizardDialogSettings == null) {
            wizardDialogSettings = pluginDialogSettings.addNewSection(settingsKey);
        }
        wizard.setDialogSettings(wizardDialogSettings);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = DawnGMFEditingDomainFactory.getInstance().createEditingDomain();
        progressMonitor.beginTask(Messages.EcoreDiagramEditorUtil_CreateDiagramProgressTask, 3);
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOConnectionUtil.instance.openSession();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        EcoreDiagramEditorPlugin.getInstance().logInfo("URI toString: " + diagramURI.toString());
        EcoreDiagramEditorPlugin.getInstance().logInfo("URI authority: " + diagramURI.authority());
        CDOTransaction transaction = CDOConnectionUtil.instance.openCurrentTransaction(resourceSet, diagramURI.toString());
        final Resource diagramResource = resourceSet.createResource(diagramURI);
        EcoreDiagramEditorPlugin.getInstance().logInfo("Diagram URI: " + diagramURI);
        EcoreDiagramEditorPlugin.getInstance().logInfo("Diagram Resource: " + diagramResource);
        CreateSemanticResourceRecordingCommand createSemanticResourceCommand = new CreateSemanticResourceRecordingCommand(editingDomain, transaction, modelURI.path());
        editingDomain.getCommandStack().execute((Command)createSemanticResourceCommand);
        final Resource modelResource = createSemanticResourceCommand.getResource();
        EcoreDiagramEditorPlugin.getInstance().logInfo("Model URI: " + modelURI);
        EcoreDiagramEditorPlugin.getInstance().logInfo("Model Resource: " + modelResource);
        final String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.EcoreDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject model = null;
                if (modelResource.getContents().size() > 0) {
                    model = (EObject)modelResource.getContents().get(0);
                } else {
                    model = DawnEcoreDiagramEditorUtil.createInitialModel();
                    DawnEcoreDiagramEditorUtil.attachModelToResource(model, modelResource);
                }
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"EcoreTools", (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement(model);
                }
                try {
                    modelResource.save(Collections.EMPTY_MAP);
                    diagramResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", (Throwable)e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", (Throwable)e);
        }
        DawnEcoreDiagramEditorUtil.setCharset((IFile)WorkspaceSynchronizer.getFile((Resource)modelResource));
        DawnEcoreDiagramEditorUtil.setCharset((IFile)WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    private static EObject createInitialModel() {
        return EcoreFactory.eINSTANCE.createEPackage();
    }

    private static void attachModelToResource(EObject model, Resource resource) {
        resource.getContents().add((Object)model);
    }

    public static Resource createDiagramOnly(URI diagramURI, URI modelURI, EObject domainElement, final boolean initializeDiagram, IProgressMonitor progressMonitor) {
        final TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask("", 3);
        final Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
        final EObject model = domainElement;
        final String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"EcoreTools", (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement(model);
                }
                try {
                    diagramResource.save(Collections.EMPTY_MAP);
                    if (initializeDiagram && diagramResource.getContents().get(0) instanceof Diagram) {
                        InitializeAndLayoutDiagramCommand initializeAndLayoutDiagram = new InitializeAndLayoutDiagramCommand(editingDomain, (Diagram)diagramResource.getContents().get(0), false);
                        OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)initializeAndLayoutDiagram, (IProgressMonitor)new NullProgressMonitor(), null);
                        diagramResource.save(EcoreDiagramEditorUtil.getSaveOptions());
                    }
                }
                catch (IOException e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Unable to store diagram resources", (Throwable)e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to create diagram", (Throwable)e);
        }
        return diagramResource;
    }
}

