/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.AcoreCreationWizard;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.AcoreDiagramEditorPlugin;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.DawnAcoreDiagramEditorUtil;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.Messages;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewDiagramResourceWizardPage;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewResourceWizardPage;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DawnAcoreCreationWizard
extends AcoreCreationWizard {
    private CDOView view;
    private DawnCreateNewDiagramResourceWizardPage dawnDiagramModelFilePage;
    private DawnCreateNewResourceWizardPage dawnDomainModelFilePage;

    public DawnAcoreCreationWizard() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = CDOConnectionUtil.instance.openView(session);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                URI diagramResourceURI = DawnAcoreCreationWizard.this.dawnDiagramModelFilePage.getURI();
                URI domainModelResourceURI = DawnAcoreCreationWizard.this.dawnDomainModelFilePage.getURI();
                DawnAcoreCreationWizard.this.diagram = DawnAcoreDiagramEditorUtil.createDiagram(diagramResourceURI, domainModelResourceURI, monitor);
                if (DawnAcoreCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && DawnAcoreCreationWizard.this.diagram != null) {
                    try {
                        DawnAcoreDiagramEditorUtil.openDiagram(DawnAcoreCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)DawnAcoreCreationWizard.this.getContainer().getShell(), (String)Messages.AcoreCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.AcoreCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                AcoreDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void addPages() {
        this.dawnDiagramModelFilePage = new DawnCreateNewDiagramResourceWizardPage("acore_diagram", false, this.view);
        this.dawnDiagramModelFilePage.setTitle(Messages.AcoreCreationWizard_DiagramModelFilePageTitle);
        this.dawnDiagramModelFilePage.setDescription(Messages.AcoreCreationWizard_DiagramModelFilePageDescription);
        this.dawnDiagramModelFilePage.setCreateAutomaticResourceName(true);
        this.addPage((IWizardPage)this.dawnDiagramModelFilePage);
        this.dawnDomainModelFilePage = new DawnCreateNewResourceWizardPage("acore", true, this.view){

            public void setVisible(boolean visible) {
                if (visible) {
                    URI uri = DawnAcoreCreationWizard.this.dawnDiagramModelFilePage.getURI();
                    String fileName = uri.lastSegment();
                    fileName = fileName.substring(0, fileName.length() - ".acore_diagram".length());
                    fileName = String.valueOf(fileName) + ".acore";
                    DawnAcoreCreationWizard.this.dawnDomainModelFilePage.setResourceNamePrefix(fileName);
                    DawnAcoreCreationWizard.this.dawnDomainModelFilePage.setResourcePath(DawnAcoreCreationWizard.this.dawnDiagramModelFilePage.getResourcePath());
                }
                super.setVisible(visible);
            }
        };
        this.dawnDomainModelFilePage.setTitle(Messages.AcoreCreationWizard_DomainModelFilePageTitle);
        this.dawnDomainModelFilePage.setDescription(Messages.AcoreCreationWizard_DomainModelFilePageDescription);
        this.dawnDomainModelFilePage.setResourceValidationType(1);
        this.addPage((IWizardPage)this.dawnDomainModelFilePage);
    }

    public void dispose() {
        this.view.close();
    }
}

