/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.navigator.AcoreAbstractNavigatorItem;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.navigator.AcoreNavigatorGroup;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.navigator.AcoreNavigatorItem;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.AcoreVisualIDRegistry;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcoreNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public AcoreNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (AcoreNavigatorContentProvider.this.myViewer != null) {
                    AcoreNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : AcoreNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (AcoreNavigatorContentProvider.this.myViewer != null) {
                    AcoreNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(AcoreNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : AcoreNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (AcoreNavigatorContentProvider.this.myViewer != null) {
                    AcoreNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(AcoreNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : AcoreNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (AcoreNavigatorContentProvider.this.myViewer != null) {
                    AcoreNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(AcoreNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList<AcoreNavigatorItem> result = new ArrayList<AcoreNavigatorItem>();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            result.addAll(this.createNavigatorItems(this.selectViewsByType(topViews, "Acore"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof AcoreNavigatorGroup) {
            AcoreNavigatorGroup group = (AcoreNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof AcoreNavigatorItem) {
            AcoreNavigatorItem navigatorItem = (AcoreNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (AcoreVisualIDRegistry.getVisualID(view)) {
            case 4001: {
                LinkedList<AcoreNavigatorGroup> result = new LinkedList<AcoreNavigatorGroup>();
                AcoreNavigatorGroup target = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassSubClasses_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                AcoreNavigatorGroup source = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassSubClasses_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4005: {
                LinkedList<AcoreNavigatorGroup> result = new LinkedList<AcoreNavigatorGroup>();
                AcoreNavigatorGroup target = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassCompositions_4005_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                AcoreNavigatorGroup source = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassCompositions_4005_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 2001: {
                LinkedList<AcoreAbstractNavigatorItem> result = new LinkedList<AcoreAbstractNavigatorItem>();
                AcoreNavigatorGroup incominglinks = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AInterface_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(7001));
                connectedViews = this.getChildrenByType(connectedViews, AcoreVisualIDRegistry.getType(3001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, AcoreVisualIDRegistry.getType(3002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 4004: {
                LinkedList<AcoreNavigatorGroup> result = new LinkedList<AcoreNavigatorGroup>();
                AcoreNavigatorGroup target = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassAggregations_4004_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                AcoreNavigatorGroup source = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassAggregations_4004_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4002: {
                LinkedList<AcoreNavigatorGroup> result = new LinkedList<AcoreNavigatorGroup>();
                AcoreNavigatorGroup target = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassImplementedInterfaces_4002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                AcoreNavigatorGroup source = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassImplementedInterfaces_4002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 2002: {
                LinkedList<AcoreAbstractNavigatorItem> result = new LinkedList<AcoreAbstractNavigatorItem>();
                AcoreNavigatorGroup incominglinks = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClass_2002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                AcoreNavigatorGroup outgoinglinks = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClass_2002_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, AcoreVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, AcoreVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4004));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4004));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 1000: {
                LinkedList<AcoreAbstractNavigatorItem> result = new LinkedList<AcoreAbstractNavigatorItem>();
                AcoreNavigatorGroup links = new AcoreNavigatorGroup(Messages.NavigatorGroupName_ACoreRoot_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4001));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4002));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4003));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4004));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(4005));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 4003: {
                LinkedList<AcoreNavigatorGroup> result = new LinkedList<AcoreNavigatorGroup>();
                AcoreNavigatorGroup target = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassAssociations_4003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                AcoreNavigatorGroup source = new AcoreNavigatorGroup(Messages.NavigatorGroupName_AClassAssociations_4003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), AcoreVisualIDRegistry.getType(2002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Acore".equals(AcoreVisualIDRegistry.getModelID(view));
    }

    private Collection<AcoreNavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<AcoreNavigatorItem> result = new ArrayList<AcoreNavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new AcoreNavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof AcoreAbstractNavigatorItem) {
            AcoreAbstractNavigatorItem abstractNavigatorItem = (AcoreAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

